/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.tree.binaryop.assignment;

import java.util.ArrayList;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.NullNode;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Expression;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.PathOutput;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Scope;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Version;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Versions;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryUndefinedBehaviorException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.misc.JsonNodeComparator;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.misc.JsonNodeUtils;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.tree.binaryop.BinaryOperatorExpression;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.path.Path;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.path.RootPath;

public class UpdateAssignment
extends BinaryOperatorExpression {
    private Version version;

    public UpdateAssignment(Expression lhs, Expression rhs, Version version) {
        super(lhs, rhs, "|=");
        this.version = version;
    }

    @Override
    public void apply(Scope scope, JsonNode in, Path ipath, PathOutput output, boolean requirePath) throws JsonQueryException {
        JsonNode[] out = new JsonNode[]{in};
        this.lhs.apply(scope, in, RootPath.getInstance(), (lval, lpath) -> {
            if (lpath == null && in.isValueNode() && JsonNodeComparator.getInstance().compare(in, lval) == 0) {
                lpath = RootPath.getInstance();
            }
            if (lpath == null) {
                throw new JsonQueryException("Invalid path expression with result %s", JsonNodeUtils.toString(lval));
            }
            out[0] = lpath.mutate(out[0], lval_ -> {
                ArrayList rvals = new ArrayList();
                this.rhs.apply(scope, lval_ == null ? NullNode.getInstance() : lval_, rvals::add);
                if (rvals.isEmpty()) {
                    throw new JsonQueryUndefinedBehaviorException("`|= empty` is undefined. See https://github.com/stedolan/jq/issues/897");
                }
                if (this.version.compareTo(Versions.JQ_1_6) >= 0) {
                    return (JsonNode)rvals.get(0);
                }
                return (JsonNode)rvals.get(rvals.size() - 1);
            });
        }, true);
        output.emit(out[0], null);
    }
}

