/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.tree;

import java.util.List;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Expression;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Function;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.PathOutput;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Scope;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Version;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.path.Path;

public class FunctionCall
implements Expression {
    private String name;
    private List<Expression> args;
    private Version version;

    public FunctionCall(String name, List<Expression> args, Version version) {
        this.name = name;
        this.args = args;
        this.version = version;
    }

    @Override
    public void apply(Scope scope, JsonNode in, Path path, PathOutput output, boolean requirePath) throws JsonQueryException {
        Function f = scope.getFunction(this.name, this.args.size());
        if (f == null) {
            throw new JsonQueryException(String.format("Function %s/%s does not exist", this.name, this.args.size()));
        }
        f.apply(scope, this.args, in, path, output, this.version);
    }

    public String toString() {
        if (this.args.isEmpty()) {
            return String.format("%s", this.name);
        }
        StringBuilder builder = new StringBuilder(this.name);
        builder.append("(");
        String sep = "";
        for (Expression arg : this.args) {
            builder.append(sep);
            if (arg == null) {
                builder.append("null");
            } else {
                builder.append(arg.toString());
            }
            sep = "; ";
        }
        builder.append(")");
        return builder.toString();
    }
}

