/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.misc;

import java.util.Arrays;
import java.util.List;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.JsonNodeType;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Expression;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.IllegalJsonArgumentException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.IllegalJsonInputException;

public class Preconditions {
    public static void checkArgumentCount(String fname, List<Expression> args, int ... nums) throws IllegalJsonArgumentException {
        int nargs = args.size();
        for (int num : nums) {
            if (nargs != num) continue;
            return;
        }
        throw new IllegalJsonArgumentException(String.format("%s takes %s arguments; got %s", fname, Arrays.toString(nums), nargs));
    }

    public static void checkInputType(String fname, JsonNode in, JsonNodeType ... types) throws IllegalJsonInputException {
        JsonNodeType t = in.getNodeType();
        for (JsonNodeType type : types) {
            if (t != type) continue;
            return;
        }
        throw new IllegalJsonInputException(String.format("%s is not applicable to %s; expected one of %s", new Object[]{fname, in.getNodeType(), Arrays.toString((Object[])types)}));
    }

    private static void checkInputElementType(String fname, JsonNode in, JsonNodeType ... types) throws IllegalJsonInputException {
        JsonNodeType t = in.getNodeType();
        for (JsonNodeType type : types) {
            if (t != type) continue;
            return;
        }
        throw new IllegalJsonInputException(String.format("%s is not applicable to input which contains %s; expected one of %s", new Object[]{fname, in.getNodeType(), Arrays.toString((Object[])types)}));
    }

    public static void checkInputArrayType(String fname, JsonNode in, JsonNodeType ... types) throws IllegalJsonInputException {
        Preconditions.checkInputType(fname, in, JsonNodeType.ARRAY);
        for (JsonNode i : in) {
            Preconditions.checkInputElementType(fname, i, types);
        }
    }

    public static void checkArgumentType(String fname, int aindex, JsonNode value, JsonNodeType ... types) throws IllegalJsonArgumentException {
        String indexText;
        JsonNodeType t = value.getNodeType();
        for (JsonNodeType type : types) {
            if (t != type) continue;
            return;
        }
        switch (aindex) {
            case 1: {
                indexText = "1st";
                break;
            }
            case 2: {
                indexText = "2nd";
                break;
            }
            case 3: {
                indexText = "3rd";
                break;
            }
            default: {
                indexText = aindex + "th";
            }
        }
        throw new IllegalJsonArgumentException(String.format("cannot accept %s as %s argument of %s; expected one of %s", new Object[]{value.getNodeType(), indexText, fname, Arrays.toString((Object[])types)}));
    }
}

