/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.misc;

import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.NullNode;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.path.ArrayIndexPath;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.path.ArrayRangeIndexPath;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.path.InvalidPath;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.path.ObjectFieldPath;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.path.Path;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.path.RootPath;

public class PathUtils {
    private static JsonNode parseArraySliceIndices(JsonNode startOrEnd) throws JsonQueryException {
        if (startOrEnd == null) {
            return NullNode.getInstance();
        }
        if (startOrEnd.isNumber()) {
            return startOrEnd;
        }
        if (startOrEnd.isNull()) {
            return startOrEnd;
        }
        throw new JsonQueryException("Start and end indices of an array slice must be numbers");
    }

    public static Path toPath(JsonNode pathObj) throws JsonQueryException {
        if (!pathObj.isArray()) {
            throw new JsonQueryException("Path must be specified as an array");
        }
        Path path = RootPath.getInstance();
        for (JsonNode segObj : pathObj) {
            if (segObj.isObject()) {
                JsonNode start = PathUtils.parseArraySliceIndices(segObj.get("start"));
                JsonNode end = PathUtils.parseArraySliceIndices(segObj.get("end"));
                path = new ArrayRangeIndexPath(path, start, end);
                continue;
            }
            if (segObj.isNumber()) {
                path = new ArrayIndexPath(path, segObj);
                continue;
            }
            if (segObj.isTextual()) {
                path = new ObjectFieldPath(path, segObj.asText());
                continue;
            }
            path = new InvalidPath(path, segObj);
        }
        return path;
    }
}

