/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.misc;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.core.JsonGenerator;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.core.Version;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonSerializer;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.SerializerProvider;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.module.SimpleModule;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.ArrayNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.DoubleNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.FloatNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.ObjectNode;

public class JsonQueryJacksonModule
extends SimpleModule {
    private static final long serialVersionUID = 1137650244815104623L;
    private static final JsonQueryJacksonModule INSTANCE = new JsonQueryJacksonModule();

    public static JsonQueryJacksonModule getInstance() {
        return INSTANCE;
    }

    private JsonQueryJacksonModule() {
        super("JsonQuery", new Version(1, 0, 0, null, "net.thisptr", "jackson-jq"));
        this.addSerializer(DoubleNode.class, new DoubleNodeSerializer());
        this.addSerializer(FloatNode.class, new FloatNodeSerializer());
        this.addSerializer(ArrayNode.class, new ArrayNodeSerializer());
        this.addSerializer(ObjectNode.class, new ObjectNodeSerializer());
    }

    private static String format(double val) {
        String repr;
        if (Double.isNaN(val)) {
            return "null";
        }
        if (Double.isInfinite(val) && val > 0.0) {
            val = Double.MAX_VALUE;
        }
        if (Double.isInfinite(val) && val < 0.0) {
            val = -1.7976931348623157E308;
        }
        String string = repr = val == (double)((long)val) ? Long.toString((long)val) : Double.toString(val);
        if (repr.contains("E-")) {
            return repr.replace('E', 'e');
        }
        return repr.replace("E", "e+");
    }

    private static class FloatNodeSerializer
    extends JsonSerializer<FloatNode> {
        private FloatNodeSerializer() {
        }

        @Override
        public void serialize(FloatNode value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeRawValue(JsonQueryJacksonModule.format(value.asDouble()));
        }
    }

    private static class DoubleNodeSerializer
    extends JsonSerializer<DoubleNode> {
        private DoubleNodeSerializer() {
        }

        @Override
        public void serialize(DoubleNode value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeRawValue(JsonQueryJacksonModule.format(value.asDouble()));
        }
    }

    private static class ObjectNodeSerializer
    extends JsonSerializer<ObjectNode> {
        private ObjectNodeSerializer() {
        }

        @Override
        public void serialize(ObjectNode value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            Iterator<Map.Entry<String, JsonNode>> iter = value.fields();
            while (iter.hasNext()) {
                Map.Entry<String, JsonNode> entry = iter.next();
                gen.writeObjectField(entry.getKey(), entry.getValue());
            }
            gen.writeEndObject();
        }
    }

    private static class ArrayNodeSerializer
    extends JsonSerializer<ArrayNode> {
        private ArrayNodeSerializer() {
        }

        @Override
        public void serialize(ArrayNode value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartArray();
            for (JsonNode element : value) {
                gen.writeObject(element);
            }
            gen.writeEndArray();
        }
    }
}

