/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.functions;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.annotation.JsonProperty;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.ObjectMapper;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.ArrayNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.BooleanNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.JsonNodeType;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Expression;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Function;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.PathOutput;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Scope;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Version;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.misc.OnigUtils;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.misc.Preconditions;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.misc.UnicodeUtils;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.path.Path;
import net.thisptr.java.prometheus.metrics.agent.shade.org.joni.Matcher;
import net.thisptr.java.prometheus.metrics.agent.shade.org.joni.Region;

@BuiltinFunction(value={"_match_impl/3"})
public class _MatchImplFunction
implements Function {
    @Override
    public void apply(Scope scope, List<Expression> args, JsonNode in, Path ipath, PathOutput output, Version version) throws JsonQueryException {
        Preconditions.checkInputType("_match_impl/3", in, JsonNodeType.STRING);
        byte[] ibytes = in.asText().getBytes(StandardCharsets.UTF_8);
        int[] cindex = UnicodeUtils.UTF8CharIndex(ibytes);
        args.get(2).apply(scope, in, test -> {
            Preconditions.checkArgumentType("_match_impl/3", 3, test, JsonNodeType.BOOLEAN);
            ((Expression)args.get(1)).apply(scope, in, flags -> {
                Preconditions.checkArgumentType("_match_impl/3", 2, flags, JsonNodeType.STRING, JsonNodeType.NULL);
                ((Expression)args.get(0)).apply(scope, in, regex -> {
                    Preconditions.checkArgumentType("_match_impl/3", 1, regex, JsonNodeType.STRING);
                    OnigUtils.Pattern p = new OnigUtils.Pattern(regex.asText(), flags.isNull() ? null : flags.asText());
                    output.emit(_MatchImplFunction.match(scope.getObjectMapper(), p, ibytes, cindex, test.asBoolean()), null);
                });
            });
        });
    }

    private static JsonNode match(ObjectMapper mapper, OnigUtils.Pattern pattern, byte[] ibytes, int[] cindex, boolean test) {
        Matcher m3 = pattern.regex.matcher(ibytes);
        if (test) {
            boolean match = m3.search(0, ibytes.length, 0) >= 0;
            return BooleanNode.valueOf(match);
        }
        ArrayNode matches = mapper.createArrayNode();
        int offset = 0;
        while (m3.search(offset, ibytes.length, 0) >= 0) {
            MatchObject obj = new MatchObject();
            obj.offset = cindex[m3.getBegin()];
            obj.length = cindex[m3.getEnd()] - cindex[m3.getBegin()];
            obj.string = new String(ibytes, m3.getBegin(), m3.getEnd() - m3.getBegin());
            Region regions = m3.getRegion();
            if (regions != null && m3.getEnd() != m3.getBegin()) {
                for (int i = 1; i < regions.numRegs; ++i) {
                    CaptureObject capture = new CaptureObject();
                    if (regions.beg[i] >= 0) {
                        capture.offset = cindex[regions.beg[i]];
                        capture.length = cindex[regions.end[i]] - cindex[regions.beg[i]];
                        capture.string = new String(ibytes, regions.beg[i], regions.end[i] - regions.beg[i], StandardCharsets.UTF_8);
                    } else {
                        capture.offset = -1;
                        capture.length = 0;
                        capture.string = null;
                    }
                    capture.name = pattern.names[i];
                    obj.captures.add(capture);
                }
            }
            matches.add((JsonNode)mapper.valueToTree(obj));
            offset = m3.getEnd() == offset ? ++offset : m3.getEnd();
            if (pattern.global && offset != ibytes.length) continue;
        }
        return matches;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class MatchObject {
        @JsonProperty(value="offset")
        public int offset;
        @JsonProperty(value="length")
        public int length;
        @JsonProperty(value="string")
        public String string;
        @JsonProperty(value="captures")
        public List<CaptureObject> captures = new ArrayList<CaptureObject>();

        MatchObject() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class CaptureObject {
        @JsonProperty(value="offset")
        public int offset;
        @JsonProperty(value="length")
        public int length;
        @JsonProperty(value="string")
        public String string;
        @JsonProperty(value="name")
        public String name;

        private CaptureObject() {
        }
    }
}

