/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.functions;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.ArrayNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.IntNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.ObjectNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.TextNode;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Expression;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Function;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.PathOutput;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Scope;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Version;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryTypeException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.path.Path;

@BuiltinFunction(value={"to_entries/0"})
public class ToEntriesFunction
implements Function {
    @Override
    public void apply(Scope scope, List<Expression> args, JsonNode in, Path ipath, PathOutput output, Version version) throws JsonQueryException {
        ArrayNode out = scope.getObjectMapper().createArrayNode();
        if (in.isObject()) {
            Iterator<Map.Entry<String, JsonNode>> iter = in.fields();
            while (iter.hasNext()) {
                Map.Entry<String, JsonNode> entry = iter.next();
                ObjectNode entryNode = scope.getObjectMapper().createObjectNode();
                entryNode.set("key", new TextNode(entry.getKey()));
                entryNode.set("value", entry.getValue());
                out.add(entryNode);
            }
        } else if (in.isArray()) {
            Iterator<JsonNode> iter = in.iterator();
            int i = 0;
            while (iter.hasNext()) {
                JsonNode value = iter.next();
                ObjectNode entryNode = scope.getObjectMapper().createObjectNode();
                entryNode.set("key", IntNode.valueOf(i));
                entryNode.set("value", value);
                out.add(entryNode);
                ++i;
            }
        } else {
            throw new JsonQueryTypeException("%s has no keys", in);
        }
        output.emit(out, null);
    }
}

