/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.functions;

import java.util.List;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.ArrayNode;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Expression;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Function;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.PathOutput;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Scope;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Version;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryTypeException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.path.Path;

@BuiltinFunction(value={"reverse/0"})
public class ReverseFunction
implements Function {
    @Override
    public void apply(Scope scope, List<Expression> args, JsonNode in, Path ipath, PathOutput output, Version version) throws JsonQueryException {
        ArrayNode out = scope.getObjectMapper().createArrayNode();
        if (in.isNull()) {
            output.emit(out, null);
            return;
        }
        if (in.isArray()) {
            for (int i = in.size() - 1; i >= 0; --i) {
                out.add(in.get(i));
            }
            output.emit(out, null);
            return;
        }
        if (in.isTextual()) {
            if (in.asText().isEmpty()) {
                output.emit(out, null);
                return;
            }
            throw new JsonQueryTypeException("Cannot index %s with number", new Object[]{in.getNodeType()});
        }
        if (in.isNumber()) {
            if (in.asDouble() == 0.0) {
                output.emit(out, null);
                return;
            }
            throw new JsonQueryTypeException("Cannot index %s with number", new Object[]{in.getNodeType()});
        }
        if (in.isObject()) {
            if (in.size() == 0) {
                output.emit(out, null);
                return;
            }
            throw new JsonQueryTypeException("Cannot index %s with number", new Object[]{in.getNodeType()});
        }
        if (in.isBoolean()) {
            throw new JsonQueryTypeException("%s has no length", in);
        }
        throw new JsonQueryTypeException("%s cannot be reversed", in);
    }
}

