/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.functions;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.IntNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.TextNode;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Expression;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Function;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.PathOutput;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Scope;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Version;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.misc.JsonNodeUtils;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.path.Path;

@BuiltinFunction(value={"paths/1"})
public class PathsFunction
implements Function {
    @Override
    public void apply(Scope scope, List<Expression> args, JsonNode in, Path ipath, PathOutput output, Version version) throws JsonQueryException {
        Stack<JsonNode> stack = new Stack<JsonNode>();
        this.applyRecursive(scope, in, output, stack, args.get(0));
    }

    private void applyRecursive(Scope scope, JsonNode in, PathOutput output, Stack<JsonNode> stack, Expression predicate) throws JsonQueryException {
        block4: {
            block3: {
                if (!stack.isEmpty()) {
                    predicate.apply(scope, in, shouldInclude -> {
                        if (JsonNodeUtils.asBoolean(shouldInclude)) {
                            output.emit(JsonNodeUtils.asArrayNode(scope.getObjectMapper(), stack), null);
                        }
                    });
                }
                if (!in.isArray()) break block3;
                for (int i = 0; i < in.size(); ++i) {
                    stack.push(new IntNode(i));
                    this.applyRecursive(scope, in.get(i), output, stack, predicate);
                    stack.pop();
                }
                break block4;
            }
            if (!in.isObject()) break block4;
            Iterator<Map.Entry<String, JsonNode>> iter = in.fields();
            while (iter.hasNext()) {
                Map.Entry<String, JsonNode> i = iter.next();
                stack.push(new TextNode(i.getKey()));
                this.applyRecursive(scope, i.getValue(), output, stack, predicate);
                stack.pop();
            }
        }
    }
}

