/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.functions;

import java.io.IOException;
import java.util.List;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.core.JsonParser;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Expression;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Function;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.PathOutput;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Scope;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Version;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryTypeException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.path.Path;

@BuiltinFunction(value={"fromjson/0"})
public class FromJsonFunction
implements Function {
    @Override
    public void apply(Scope scope, List<Expression> args, JsonNode in, Path ipath, PathOutput output, Version version) throws JsonQueryException {
        JsonNode tree;
        if (!in.isTextual()) {
            throw new JsonQueryTypeException("%s only strings can be parsed", in);
        }
        try (JsonParser parser = scope.getObjectMapper().getFactory().createParser(in.asText());){
            tree = (JsonNode)parser.readValueAsTree();
            if (tree == null) {
                throw new JsonQueryException("failed to parse %s as json; empty", in);
            }
            if (parser.nextToken() != null) {
                throw new JsonQueryException("failed to parse %s as json; trailing data", in);
            }
        }
        catch (JsonQueryException e) {
            throw e;
        }
        catch (IOException e) {
            throw new JsonQueryException("failed to parse %s as json", in);
        }
        output.emit(tree, null);
    }
}

