/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.functions;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.BooleanNode;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Expression;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Function;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.PathOutput;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Scope;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Version;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryTypeException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.misc.JsonNodeComparator;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.path.Path;

@BuiltinFunction(value={"contains/1"})
public class ContainsFunction
implements Function {
    private static final JsonNodeComparator COMPARATOR = JsonNodeComparator.getInstance();

    @Override
    public void apply(Scope scope, List<Expression> args, JsonNode in, Path ipath, PathOutput output, Version version) throws JsonQueryException {
        args.get(0).apply(scope, in, value -> {
            if (in.getNodeType() != value.getNodeType() || in.isBoolean() && in.asBoolean() != value.asBoolean()) {
                throw new JsonQueryTypeException("%s and %s cannot have their containment checked", in, value);
            }
            output.emit(BooleanNode.valueOf(ContainsFunction.contains(value, in)), null);
        });
    }

    private static boolean contains(JsonNode needle, JsonNode haystack) {
        if (haystack.isTextual() && needle.isTextual()) {
            return haystack.asText().contains(needle.asText());
        }
        if (haystack.isArray() && needle.isArray()) {
            for (JsonNode n : needle) {
                boolean found = false;
                for (JsonNode h2 : haystack) {
                    if (!ContainsFunction.contains(n, h2)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
        if (haystack.isObject() && needle.isObject()) {
            Iterator<Map.Entry<String, JsonNode>> iter = needle.fields();
            while (iter.hasNext()) {
                Map.Entry<String, JsonNode> field = iter.next();
                JsonNode tmp = haystack.get(field.getKey());
                if (tmp == null) {
                    return false;
                }
                if (ContainsFunction.contains(field.getValue(), tmp)) continue;
                return false;
            }
            return true;
        }
        return COMPARATOR.compare(haystack, needle) == 0;
    }
}

