/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.extra.functions;

import java.net.InetAddress;
import java.util.List;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.NullNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.TextNode;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Expression;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Function;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.PathOutput;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Scope;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Version;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.path.Path;

@BuiltinFunction(value={"hostname/0", "hostname/1"})
public class HostnameFunction
implements Function {
    private JsonNode hostname = NullNode.getInstance();
    private JsonNode fqdn = NullNode.getInstance();

    public HostnameFunction() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            this.hostname = new TextNode(addr.getHostName());
            this.fqdn = new TextNode(addr.getCanonicalHostName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void apply(Scope scope, List<Expression> args, JsonNode in, Path ipath, PathOutput output, Version version) throws JsonQueryException {
        if (args.size() == 1) {
            args.get(0).apply(scope, in, arg -> {
                if (arg.isTextual() && "fqdn".equals(arg.asText())) {
                    output.emit(this.fqdn, null);
                } else {
                    output.emit(this.hostname, null);
                }
            });
        } else {
            output.emit(this.hostname, null);
        }
    }
}

