/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version
implements Comparable<Version> {
    public final int major;
    public final int minor;
    public static final Version LATEST = new Version(Integer.MAX_VALUE, Integer.MAX_VALUE);
    public static Pattern VERSION_PATTERN = Pattern.compile("([0-9])\\.([0-9])");

    Version(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    @Override
    public int compareTo(Version o) {
        int r = Integer.compare(this.major, o.major);
        if (r != 0) {
            return r;
        }
        return Integer.compare(this.minor, o.minor);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        if (this.major != other.major) {
            return false;
        }
        return this.minor == other.minor;
    }

    public int majorVersion() {
        return this.major;
    }

    public int minorVersion() {
        return this.minor;
    }

    public static Version valueOf(String text) {
        Matcher m3 = VERSION_PATTERN.matcher(text);
        if (!m3.matches()) {
            throw new IllegalArgumentException("Invalid Version: " + text);
        }
        String majorVersion = m3.group(1);
        String minorVersion = m3.group(2);
        return new Version(Integer.parseInt(majorVersion), Integer.parseInt(minorVersion));
    }

    public String toString() {
        return this.major + "." + this.minor;
    }
}

