/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.scraper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import net.thisptr.java.prometheus.metrics.agent.Sample;
import net.thisptr.java.prometheus.metrics.agent.misc.AttributeNamePattern;
import net.thisptr.java.prometheus.metrics.agent.scraper.ScrapeOutput;
import net.thisptr.java.prometheus.metrics.agent.scraper.ScrapeRule;
import net.thisptr.java.prometheus.metrics.agent.shade.com.google.common.cache.CacheBuilder;
import net.thisptr.java.prometheus.metrics.agent.shade.com.google.common.cache.CacheLoader;
import net.thisptr.java.prometheus.metrics.agent.shade.com.google.common.cache.LoadingCache;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.misc.Pair;

public class Scraper<ScrapeRuleType extends ScrapeRule> {
    private static final Logger LOG = Logger.getLogger(Scraper.class.getName());
    private final List<ScrapeRuleType> rules;
    private final MBeanServer server;
    private final LoadingCache<ObjectName, MBeanInfo> mbeanInfoCache = CacheBuilder.newBuilder().refreshAfterWrite(60L, TimeUnit.SECONDS).build(new CacheLoader<ObjectName, MBeanInfo>(){

        @Override
        public MBeanInfo load(ObjectName name) throws Exception {
            return Scraper.this.server.getMBeanInfo(name);
        }
    });
    private final LoadingCache<ObjectName, Set<String>> attributeBlacklist = CacheBuilder.newBuilder().expireAfterWrite(600L, TimeUnit.SECONDS).build(new CacheLoader<ObjectName, Set<String>>(){

        @Override
        public Set<String> load(ObjectName name) {
            return Collections.newSetFromMap(new ConcurrentHashMap());
        }
    });

    public Scraper(MBeanServer server, List<ScrapeRuleType> rules) {
        this.server = server;
        this.rules = rules;
    }

    private Pair<Boolean, ScrapeRuleType> findRuleEarly(ObjectName name) {
        for (ScrapeRule rule : this.rules) {
            if (rule.patterns() == null || rule.patterns().isEmpty()) {
                return Pair.of(true, rule);
            }
            boolean nameMatches = false;
            for (AttributeNamePattern pattern : rule.patterns()) {
                if (!pattern.nameMatches(name)) continue;
                nameMatches = true;
                if (pattern.attribute != null) continue;
                return Pair.of(true, rule);
            }
            if (!nameMatches) continue;
            return Pair.of(false, null);
        }
        return Pair.of(true, null);
    }

    private ScrapeRuleType findRule(ObjectName name, String attribute) {
        for (ScrapeRule rule : this.rules) {
            if (rule.patterns() == null || rule.patterns().isEmpty()) {
                return (ScrapeRuleType)rule;
            }
            for (AttributeNamePattern pattern : rule.patterns()) {
                if (!pattern.matches(name, attribute)) continue;
                return (ScrapeRuleType)rule;
            }
        }
        return null;
    }

    public void scrape(ScrapeOutput<ScrapeRuleType> output) throws InterruptedException {
        this.scrape(output, 0L, TimeUnit.MILLISECONDS);
    }

    public void scrape(ScrapeOutput<ScrapeRuleType> output, long duration, TimeUnit unit) throws InterruptedException {
        Set<ObjectName> names;
        ArrayList<AttributeScrapeRequest> requests = new ArrayList<AttributeScrapeRequest>();
        try {
            names = this.server.queryNames(null, null);
        }
        catch (Throwable th) {
            LOG.log(Level.WARNING, "Failed to enumerate MBean names.", th);
            return;
        }
        for (ObjectName name : names) {
            MBeanInfo info;
            Pair<Boolean, ScrapeRuleType> ruleByName = this.findRuleEarly(name);
            if (((Boolean)ruleByName._1).booleanValue() && ruleByName._2 != null && ((ScrapeRule)ruleByName._2).skip()) continue;
            try {
                info = this.mbeanInfoCache.get(name);
            }
            catch (Throwable th) {
                LOG.log(Level.FINER, "Failed to obtain MBeanInfo (name = " + name + ")", th);
                continue;
            }
            Set bannedAttributes = (Set)this.attributeBlacklist.getIfPresent(name);
            for (MBeanAttributeInfo attribute : info.getAttributes()) {
                try {
                    ScrapeRule rule;
                    if (!attribute.isReadable() || bannedAttributes != null && bannedAttributes.contains(attribute.getName())) continue;
                    if (((Boolean)ruleByName._1).booleanValue()) {
                        rule = (ScrapeRule)ruleByName._2;
                    } else {
                        rule = this.findRule(name, attribute.getName());
                        if (rule != null && rule.skip()) continue;
                    }
                    requests.add(new AttributeScrapeRequest(this, name, info, attribute, rule));
                }
                catch (Throwable th) {
                    LOG.log(Level.WARNING, "Failed to process MBean attribute (name = " + name + ", attribute = " + attribute.getName() + ").", th);
                }
            }
        }
        long startNanos = System.nanoTime();
        long durationNanos = unit.toNanos(duration);
        for (int i = 0; i < requests.size(); ++i) {
            long waitUntilNanos = startNanos + (long)((double)(i + 1) / (double)requests.size() * (double)durationNanos);
            long sleepNanos = waitUntilNanos - System.nanoTime();
            if (sleepNanos > 10000000L) {
                Scraper.sleepNanos(sleepNanos);
            }
            AttributeScrapeRequest request = (AttributeScrapeRequest)requests.get(i);
            try {
                this.scrape(request.name, request.info, request.attribute, request.rule, output);
                continue;
            }
            catch (Throwable th) {
                LOG.log(Level.FINER, "Failed to scrape the attribute of the MBean instance (name = " + request.name + ", attribute = " + request.attribute.getName() + ")", th);
            }
        }
        long waitUntilNanos = startNanos + durationNanos;
        long sleepNanos = waitUntilNanos - System.nanoTime();
        if (sleepNanos > 0L) {
            Scraper.sleepNanos(sleepNanos);
        }
    }

    private static void sleepNanos(long totalNanos) throws InterruptedException {
        int nanos = (int)(totalNanos % 1000000L);
        long millis = totalNanos / 1000000L;
        Thread.sleep(millis, nanos);
    }

    private void scrape(ObjectName name, MBeanInfo info, MBeanAttributeInfo attribute, ScrapeRuleType rule, ScrapeOutput<ScrapeRuleType> output) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException {
        Object value;
        long timestamp = System.currentTimeMillis();
        try {
            value = this.server.getAttribute(name, attribute.getName());
        }
        catch (RuntimeMBeanException e) {
            if (e.getCause() instanceof UnsupportedOperationException) {
                this.blacklist(name, info, attribute);
                return;
            }
            throw e;
        }
        output.emit(new Sample<ScrapeRuleType>(rule, timestamp, name, info, attribute, value));
    }

    private void blacklist(ObjectName name, MBeanInfo info, MBeanAttributeInfo attribute) {
        this.attributeBlacklist.getUnchecked(name).add(attribute.getName());
    }

    private static class AttributeScrapeRequest {
        public final ObjectName name;
        public final MBeanInfo info;
        public final MBeanAttributeInfo attribute;
        public final ScrapeRuleType rule;
        final /* synthetic */ Scraper this$0;

        public AttributeScrapeRequest(ObjectName name, MBeanInfo info, MBeanAttributeInfo attribute, ScrapeRuleType rule) {
            this.this$0 = var1_1;
            this.name = name;
            this.info = info;
            this.attribute = attribute;
            this.rule = rule;
        }
    }
}

