/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.misc;

import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import net.thisptr.java.prometheus.metrics.agent.javacc.AttributeNamePatternParser;

public class AttributeNamePattern {
    public final Pattern domain;
    public final Map<String, Pattern> keys;
    public final Pattern attribute;

    public AttributeNamePattern(String domain, Map<String, String> keys, String attribute) {
        this.domain = domain != null ? Pattern.compile(domain) : null;
        LinkedHashMap tmp = new LinkedHashMap();
        keys.forEach((k, v) -> tmp.put(k, Pattern.compile(v)));
        this.keys = Collections.unmodifiableMap(tmp);
        this.attribute = attribute != null ? Pattern.compile(attribute) : null;
    }

    public boolean matches(ObjectName name, String attribute) {
        if (!this.nameMatches(name)) {
            return false;
        }
        return this.attribute == null || attribute != null && this.attribute.matcher(attribute).matches();
    }

    public static AttributeNamePattern compile(String patternText) {
        return AttributeNamePatternParser.parse(patternText);
    }

    public boolean nameMatches(ObjectName name) {
        if (this.domain != null && !this.domain.matcher(name.getDomain()).matches()) {
            return false;
        }
        Hashtable<String, String> target = name.getKeyPropertyList();
        for (Map.Entry<String, Pattern> patternEntry : this.keys.entrySet()) {
            String targetValue = (String)target.get(patternEntry.getKey());
            if (targetValue == null) {
                return false;
            }
            if (targetValue.startsWith("\"")) {
                targetValue = ObjectName.unquote(targetValue);
            }
            if (patternEntry.getValue().matcher(targetValue).matches()) continue;
            return false;
        }
        return true;
    }
}

