/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.config;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.thisptr.java.prometheus.metrics.agent.config.Config;
import net.thisptr.java.prometheus.metrics.agent.config.ConfigWatcher;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.core.JsonParseException;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonMappingException;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.ObjectMapper;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import net.thisptr.java.prometheus.metrics.agent.shade.com.google.common.io.Files;
import net.thisptr.java.prometheus.metrics.agent.utils.MoreValidators;

public class FileConfigWatcher
extends Thread
implements ConfigWatcher {
    private static final Logger LOG = Logger.getLogger(FileConfigWatcher.class.getName());
    private static final ObjectMapper YAML_MAPPER = new ObjectMapper(new YAMLFactory());
    private final File file;
    private final ConfigWatcher.ConfigListener listener;
    private volatile Config config;
    private volatile byte[] bytes;

    public FileConfigWatcher(File file, ConfigWatcher.ConfigListener listener) throws JsonParseException, JsonMappingException, IOException {
        this.file = file;
        this.bytes = Files.toByteArray(file);
        this.config = YAML_MAPPER.readValue(this.bytes, Config.class);
        MoreValidators.validate(this.config);
        this.listener = listener;
        this.setName("Prometheus Metrics Agent " + FileConfigWatcher.class.getSimpleName());
        this.setDaemon(true);
    }

    @Override
    public void run() {
        while (true) {
            Config newConfig;
            byte[] newBytes;
            block10: {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    LOG.log(Level.INFO, "Interrupted. Stopping Prometheus Metrics Agent " + FileConfigWatcher.class.getSimpleName() + "...");
                    break;
                }
                try {
                    newBytes = Files.toByteArray(this.file);
                    if (Arrays.equals(this.bytes, newBytes)) {
                    }
                    break block10;
                }
                catch (Throwable th) {
                    LOG.log(Level.WARNING, "Got exception while reloading " + this.file.getAbsolutePath() + ".", th);
                }
                continue;
            }
            try {
                newConfig = YAML_MAPPER.readValue(newBytes, Config.class);
                MoreValidators.validate(newConfig);
            }
            catch (Throwable th) {
                LOG.log(Level.WARNING, "Got exception while reloading " + this.file.getAbsolutePath() + ".", th);
                continue;
            }
            try {
                this.listener.changed(this.config, newConfig);
            }
            catch (Throwable th) {
                LOG.log(Level.WARNING, "Got exception while reconfiguring from " + this.file.getAbsolutePath() + ".", th);
            }
            this.config = newConfig;
            this.bytes = newBytes;
        }
    }

    @Override
    public Config config() {
        return this.config;
    }

    @Override
    public void shutdown() {
        this.interrupt();
    }
}

