/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;
import net.thisptr.java.prometheus.metrics.agent.jackson.JmxModule;
import net.thisptr.java.prometheus.metrics.agent.scraper.ScrapeRule;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.MapperFeature;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.ObjectMapper;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.ArrayNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.BooleanNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.DoubleNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.FloatNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.IntNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.LongNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.NullNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.ObjectNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.TextNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.google.common.collect.Maps;

public class Sample<ScrapeRuleType extends ScrapeRule> {
    public static final ObjectMapper JMX_MAPPER = new ObjectMapper().registerModule(new JmxModule()).disable(MapperFeature.AUTO_DETECT_GETTERS).disable(MapperFeature.AUTO_DETECT_FIELDS).disable(MapperFeature.AUTO_DETECT_IS_GETTERS).disable(MapperFeature.AUTO_DETECT_SETTERS).disable(MapperFeature.AUTO_DETECT_CREATORS);
    public final ScrapeRuleType rule;
    public final long timestamp;
    public final MBeanAttributeInfo attribute;
    public final Object value;
    public final ObjectName name;
    public final MBeanInfo info;

    public Sample(ScrapeRuleType rule, long timestamp, ObjectName name, MBeanInfo info, MBeanAttributeInfo attribute, Object value) {
        this.rule = rule;
        this.timestamp = timestamp;
        this.name = name;
        this.info = info;
        this.attribute = attribute;
        this.value = value;
    }

    private static JsonNode serializeCompositeData(CompositeData data, CompositeType type) {
        Set<String> keys = type.keySet();
        HashMap<String, JsonNode> root = Maps.newHashMapWithExpectedSize(keys.size() + 1);
        root.put("$type", TextNode.valueOf("javax.management.openmbean.CompositeData"));
        for (String key : keys) {
            root.put(key, Sample.serialize(data.get(key)));
        }
        return new ObjectNode(JMX_MAPPER.getNodeFactory(), root);
    }

    private static JsonNode serializeCompositeData(CompositeData data) {
        CompositeType type = data.getCompositeType();
        return Sample.serializeCompositeData(data, type);
    }

    private static JsonNode serializeTabularData(TabularData data) {
        TabularType type = data.getTabularType();
        CompositeType rowType = type.getRowType();
        HashMap<String, JsonNode> root = Maps.newHashMapWithExpectedSize(3);
        root.put("$type", TextNode.valueOf("javax.management.openmbean.TabularData"));
        Collection<?> values = data.values();
        ArrayList<JsonNode> jsonValues = new ArrayList<JsonNode>(values.size());
        for (Object value : values) {
            jsonValues.add(Sample.serializeCompositeData((CompositeData)value, rowType));
        }
        root.put("values", new ArrayNode(JMX_MAPPER.getNodeFactory(), jsonValues));
        List<String> indexNames = type.getIndexNames();
        ArrayList<JsonNode> jsonIndexNames = new ArrayList<JsonNode>(indexNames.size());
        for (String indexName : indexNames) {
            jsonIndexNames.add(TextNode.valueOf(indexName));
        }
        HashMap<String, JsonNode> jsonTabularType = Maps.newHashMapWithExpectedSize(1);
        jsonTabularType.put("index_names", new ArrayNode(JMX_MAPPER.getNodeFactory(), jsonIndexNames));
        root.put("tabular_type", new ObjectNode(JMX_MAPPER.getNodeFactory(), jsonTabularType));
        return new ObjectNode(JMX_MAPPER.getNodeFactory(), root);
    }

    private static JsonNode serializeObjectName(ObjectName name) {
        return TextNode.valueOf(name.toString());
    }

    private static JsonNode serialize(Object value) {
        if (value == null) {
            return NullNode.getInstance();
        }
        if (value instanceof Long) {
            return LongNode.valueOf((Long)value);
        }
        if (value instanceof Integer) {
            return IntNode.valueOf((Integer)value);
        }
        if (value instanceof Double) {
            return DoubleNode.valueOf((Double)value);
        }
        if (value instanceof Float) {
            return FloatNode.valueOf(((Float)value).floatValue());
        }
        if (value instanceof Boolean) {
            return BooleanNode.valueOf((Boolean)value);
        }
        if (value instanceof String) {
            return TextNode.valueOf((String)value);
        }
        if (value instanceof CompositeData) {
            return Sample.serializeCompositeData((CompositeData)value);
        }
        if (value instanceof TabularData) {
            return Sample.serializeTabularData((TabularData)value);
        }
        if (value instanceof ObjectName) {
            return Sample.serializeObjectName((ObjectName)value);
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            ArrayList<JsonNode> root = new ArrayList<JsonNode>(length);
            for (int i = 0; i < length; ++i) {
                root.add(Sample.serialize(Array.get(value, i)));
            }
            return new ArrayNode(JMX_MAPPER.getNodeFactory(), root);
        }
        return JMX_MAPPER.valueToTree(value);
    }

    public JsonNode toJsonNode() {
        JsonNode valueJson = Sample.serialize(this.value);
        HashMap<String, JsonNode> out = Maps.newHashMapWithExpectedSize(6);
        out.put("type", TextNode.valueOf(this.attribute.getType()));
        out.put("value", valueJson != null ? valueJson : NullNode.getInstance());
        out.put("domain", TextNode.valueOf(this.name.getDomain()));
        Hashtable<String, String> propertyList = this.name.getKeyPropertyList();
        HashMap<String, JsonNode> properties = Maps.newHashMapWithExpectedSize(propertyList.size());
        propertyList.forEach((k, v) -> {
            if (v.startsWith("\"")) {
                v = ObjectName.unquote(v);
            }
            properties.put((String)k, TextNode.valueOf(v));
        });
        out.put("properties", new ObjectNode(JMX_MAPPER.getNodeFactory(), properties));
        out.put("attribute", TextNode.valueOf(this.attribute.getName()));
        out.put("timestamp", LongNode.valueOf(this.timestamp));
        return new ObjectNode(JMX_MAPPER.getNodeFactory(), out);
    }
}

