/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent;

import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.thisptr.java.prometheus.metrics.agent.PrometheusMetric;
import net.thisptr.java.prometheus.metrics.agent.Sample;
import net.thisptr.java.prometheus.metrics.agent.config.Config;
import net.thisptr.java.prometheus.metrics.agent.scraper.ScrapeOutput;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Scope;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Versions;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;

public class PrometheusScrapeOutput
implements ScrapeOutput<Config.PrometheusScrapeRule> {
    private static final Logger LOG = Logger.getLogger(PrometheusScrapeOutput.class.getName());
    public static final JsonQuery DEFAULT_TRANSFORM;
    private final Scope scope;
    private final PrometheusMetricOutput output;
    private final Consumer<JsonNode> debugOutput;

    public PrometheusScrapeOutput(Scope scope, PrometheusMetricOutput output) {
        this(scope, output, raw -> {});
    }

    public PrometheusScrapeOutput(Scope scope, PrometheusMetricOutput output, Consumer<JsonNode> debugOutput) {
        this.scope = scope;
        this.output = output;
        this.debugOutput = debugOutput;
    }

    @Override
    public void emit(Sample<Config.PrometheusScrapeRule> sample) {
        JsonNode mbeanAttributeNode = sample.toJsonNode();
        JsonQuery transform = sample.rule != null && ((Config.PrometheusScrapeRule)sample.rule).transform != null ? ((Config.PrometheusScrapeRule)sample.rule).transform : DEFAULT_TRANSFORM;
        ArrayList metricNodes = new ArrayList();
        try {
            transform.apply(this.scope, mbeanAttributeNode, metricNodes::add);
        }
        catch (Throwable th) {
            LOG.log(Level.INFO, "Failed to transform a MBean attribute (" + mbeanAttributeNode + ") to Prometheus metrics.", th);
            return;
        }
        for (JsonNode metricNode : metricNodes) {
            PrometheusMetric metric;
            try {
                this.debugOutput.accept(metricNode);
            }
            catch (Throwable th) {
                LOG.log(Level.FINEST, "Swallowed an exception ocurred during a debug output.", th);
            }
            try {
                metric = PrometheusMetric.fromJsonNode(metricNode);
            }
            catch (Throwable th) {
                LOG.log(Level.INFO, "Failed to map a Prometheus metric JSON (" + metricNode + ") to an object.", th);
                continue;
            }
            if (metric.timestamp == null) {
                metric.timestamp = sample.timestamp;
            }
            this.output.emit(metric);
        }
    }

    static {
        try {
            DEFAULT_TRANSFORM = JsonQuery.compile("default_transform_v1", Versions.JQ_1_6);
        }
        catch (JsonQueryException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface PrometheusMetricOutput {
        public void emit(PrometheusMetric var1);
    }
}

