/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import net.thisptr.java.prometheus.metrics.agent.PrometheusMetric;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;

public class PrometheusMetricWriter
implements Closeable {
    private final StringBuilder builder;
    private final boolean includeTimestamp;

    public PrometheusMetricWriter(StringBuilder builder, boolean includeTimestamp) {
        this.builder = builder;
        this.includeTimestamp = includeTimestamp;
    }

    private static void sanitizeMetricName(StringBuilder builder, String name) {
        if (name.isEmpty()) {
            builder.append('_');
            return;
        }
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            boolean valid;
            char ch = name.charAt(i);
            boolean bl = valid = 'a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9' && i != 0 || ch == '_' || ch == ':';
            if (valid) {
                builder.append(ch);
                continue;
            }
            builder.append('_');
        }
    }

    private static void sanitizeLabelName(StringBuilder builder, String name) {
        if (name.isEmpty()) {
            builder.append('_');
            return;
        }
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            boolean valid;
            char ch = name.charAt(i);
            boolean bl = valid = 'a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9' && i != 0 || ch == '_';
            if (valid) {
                builder.append(ch);
                continue;
            }
            builder.append('_');
        }
    }

    public void write(PrometheusMetric metric) throws IOException {
        PrometheusMetricWriter.sanitizeMetricName(this.builder, metric.name);
        if (!metric.labels.isEmpty()) {
            this.builder.append('{');
            for (Map.Entry<String, JsonNode> entry : metric.labels.entrySet()) {
                PrometheusMetricWriter.sanitizeLabelName(this.builder, entry.getKey());
                this.builder.append('=');
                PrometheusMetricWriter.sanitizeLabelValue(this.builder, entry.getValue());
                this.builder.append(',');
            }
            this.builder.append('}');
        }
        this.builder.append(' ');
        this.builder.append(metric.value);
        if (this.includeTimestamp && metric.timestamp != null) {
            this.builder.append(' ');
            this.builder.append(metric.timestamp);
        }
        this.builder.append('\n');
    }

    private static void sanitizeLabelValue(StringBuilder builder, JsonNode value) {
        if (value == null || value.isNull()) {
            builder.append('\"');
            builder.append("null");
            builder.append('\"');
        } else {
            builder.append('\"');
            String text = value.isTextual() ? value.asText() : value.toString();
            int length = text.length();
            block5: for (int i = 0; i < length; ++i) {
                char ch = text.charAt(i);
                switch (ch) {
                    case '\\': {
                        builder.append('\\');
                        builder.append('\\');
                        continue block5;
                    }
                    case '\n': {
                        builder.append('\\');
                        builder.append('\n');
                        continue block5;
                    }
                    case '\"': {
                        builder.append('\\');
                        builder.append('\"');
                        continue block5;
                    }
                    default: {
                        builder.append(ch);
                    }
                }
            }
            builder.append('\"');
        }
    }

    @Override
    public void close() throws IOException {
    }
}

