/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent;

import java.util.Iterator;
import java.util.Map;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.annotation.JsonInclude;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.annotation.JsonProperty;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.google.common.collect.Maps;

public class PrometheusMetric {
    @JsonProperty(value="name")
    public String name;
    @JsonProperty(value="labels")
    public Map<String, JsonNode> labels;
    @JsonProperty(value="value")
    public double value;
    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long timestamp = null;

    public static PrometheusMetric fromJsonNode(JsonNode tree) {
        PrometheusMetric m3 = new PrometheusMetric();
        JsonNode name = tree.get("name");
        m3.name = name != null ? name.asText() : null;
        JsonNode value = tree.get("value");
        m3.value = value != null ? value.asDouble() : 0.0;
        JsonNode timestamp = tree.get("timestamp");
        m3.timestamp = timestamp != null ? Long.valueOf(timestamp.asLong()) : null;
        JsonNode labels = tree.get("labels");
        if (labels != null) {
            m3.labels = Maps.newHashMapWithExpectedSize(labels.size());
            Iterator<Map.Entry<String, JsonNode>> iter = labels.fields();
            while (iter.hasNext()) {
                Map.Entry<String, JsonNode> entry = iter.next();
                m3.labels.put(entry.getKey(), entry.getValue());
            }
        } else {
            m3.labels = null;
        }
        return m3;
    }
}

