/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent;

import java.io.IOException;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import net.thisptr.java.prometheus.metrics.agent.PrometheusExporterServer;
import net.thisptr.java.prometheus.metrics.agent.PrometheusMetric;
import net.thisptr.java.prometheus.metrics.agent.PrometheusMetricWriter;
import net.thisptr.java.prometheus.metrics.agent.PrometheusScrapeOutput;
import net.thisptr.java.prometheus.metrics.agent.RootScope;
import net.thisptr.java.prometheus.metrics.agent.config.Config;
import net.thisptr.java.prometheus.metrics.agent.scraper.Scraper;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.core.JsonParser;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.core.type.TypeReference;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.ObjectMapper;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.NullNode;
import net.thisptr.java.prometheus.metrics.agent.shade.fi.iki.elonen.NanoHTTPD;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.JsonQuery;

public class PrometheusExporterServerHandler {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final Scraper<Config.PrometheusScrapeRule> scraper;
    private final JsonQuery labels;
    private final Config.OptionsConfig options;

    public PrometheusExporterServerHandler(List<Config.PrometheusScrapeRule> rules, JsonQuery labels, Config.OptionsConfig options) {
        this.labels = labels;
        this.options = options;
        this.scraper = new Scraper<Config.PrometheusScrapeRule>(ManagementFactory.getPlatformMBeanServer(), rules);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, JsonNode> makeLabels() throws IOException {
        if (this.labels == null) {
            return Collections.emptyMap();
        }
        ArrayList nodes = new ArrayList();
        this.labels.apply(RootScope.getInstance(), NullNode.getInstance(), nodes::add);
        if (nodes.isEmpty()) {
            return Collections.emptyMap();
        }
        JsonNode in = (JsonNode)nodes.get(nodes.size() - 1);
        try (JsonParser jp = MAPPER.treeAsTokens(in);){
            Map map = (Map)MAPPER.readValue(jp, new TypeReference<Map<String, JsonNode>>(){});
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot deserialize labels from input: " + in, e);
        }
    }

    private Config.OptionsConfig getOptions(NanoHTTPD.IHTTPSession session) {
        Config.OptionsConfig options = new Config.OptionsConfig();
        options.includeTimestamp = Optional.ofNullable(session.getParameters().get("include_timestamp")).filter(args -> !args.isEmpty()).map(args -> Boolean.parseBoolean((String)args.get(0))).orElse(this.options.includeTimestamp);
        options.minimumResponseTime = Optional.ofNullable(session.getParameters().get("minimum_response_time")).filter(args -> !args.isEmpty()).map(args -> Math.max(0L, Math.min(60000L, Long.parseLong((String)args.get(0))))).orElse(this.options.minimumResponseTime);
        return options;
    }

    public NanoHTTPD.Response handleGetMetrics(NanoHTTPD.IHTTPSession session) throws InterruptedException, IOException {
        Map<String, JsonNode> labels = this.makeLabels();
        Config.OptionsConfig options = this.getOptions(session);
        TreeMap<String, List> allMetrics = new TreeMap<String, List>();
        this.scraper.scrape(new PrometheusScrapeOutput(RootScope.getInstance(), metric -> {
            if (metric.labels == null) {
                metric.labels = new HashMap<String, JsonNode>();
            }
            metric.labels.putAll(labels);
            allMetrics.computeIfAbsent(metric.name, name -> new ArrayList()).add(metric);
        }), options.minimumResponseTime, TimeUnit.MILLISECONDS);
        StringBuilder builder = new StringBuilder();
        try (PrometheusMetricWriter pwriter = new PrometheusMetricWriter(builder, options.includeTimestamp);){
            allMetrics.forEach((name, metrics) -> metrics.forEach(metric -> {
                try {
                    pwriter.write((PrometheusMetric)metric);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }));
        }
        return PrometheusExporterServer.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, "text/plain; version=0.0.4; charset=utf-8", builder.toString());
    }

    public NanoHTTPD.Response handleGetMBeans(NanoHTTPD.IHTTPSession session) throws InterruptedException {
        StringWriter writer = new StringWriter();
        this.scraper.scrape(sample -> {
            writer.write(sample.toJsonNode().toString());
            writer.write(10);
        });
        return PrometheusExporterServer.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, "text/plain; charset=utf-8", writer.toString());
    }

    public NanoHTTPD.Response handleGetMetricsRaw(NanoHTTPD.IHTTPSession session) throws InterruptedException {
        StringWriter writer = new StringWriter();
        this.scraper.scrape(new PrometheusScrapeOutput(RootScope.getInstance(), metric -> {}, raw -> {
            writer.write(raw.toString());
            writer.write(10);
        }));
        return PrometheusExporterServer.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, "text/plain; charset=utf-8", writer.toString());
    }
}

