/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent;

import java.util.Iterator;
import java.util.Map;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.annotation.JsonProperty;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.google.common.collect.Maps;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JsonSample {
    @JsonProperty(value="type")
    public String type;
    @JsonProperty(value="value")
    public JsonNode value;
    @JsonProperty(value="domain")
    public String domain;
    @JsonProperty(value="properties")
    public Map<String, JsonNode> properties;
    @JsonProperty(value="timestamp")
    public long timestamp;
    @JsonProperty(value="attribute")
    public String attribute;

    public static JsonSample fromJsonNode(JsonNode tree) {
        JsonNode timestamp;
        JsonSample sample = new JsonSample();
        JsonNode type = tree.get("type");
        sample.type = type != null ? type.asText() : null;
        sample.value = tree.get("value");
        sample.domain = tree.get("domain").asText();
        JsonNode properties = tree.get("properties");
        if (properties != null) {
            sample.properties = Maps.newHashMapWithExpectedSize(properties.size());
            Iterator<Map.Entry<String, JsonNode>> iter = properties.fields();
            while (iter.hasNext()) {
                Map.Entry<String, JsonNode> entry = iter.next();
                sample.properties.put(entry.getKey(), entry.getValue());
            }
        } else {
            sample.properties = null;
        }
        sample.timestamp = (timestamp = tree.get("timestamp")) != null ? timestamp.asLong() : 0L;
        sample.attribute = tree.get("attribute").asText();
        return sample;
    }
}

