/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.thisptr.java.prometheus.metrics.agent.PrometheusExporterServer;
import net.thisptr.java.prometheus.metrics.agent.PrometheusExporterServerHandler;
import net.thisptr.java.prometheus.metrics.agent.config.Config;
import net.thisptr.java.prometheus.metrics.agent.config.ConfigWatcher;
import net.thisptr.java.prometheus.metrics.agent.config.FileConfigWatcher;
import net.thisptr.java.prometheus.metrics.agent.config.StaticConfigWatcher;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.core.JsonParseException;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonMappingException;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.ObjectMapper;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import net.thisptr.java.prometheus.metrics.agent.shade.fi.iki.elonen.NanoHTTPD;
import net.thisptr.java.prometheus.metrics.agent.utils.MoreValidators;

public class Agent {
    private static final Logger LOG = Logger.getLogger(Agent.class.getName());
    private static final ObjectMapper MAPPER = new ObjectMapper(new YAMLFactory());
    private static PrometheusExporterServer SERVER;

    private static ConfigWatcher newConfigWatcher(String args, ConfigWatcher.ConfigListener listener) throws JsonParseException, JsonMappingException, IOException {
        if (args == null || args.isEmpty()) {
            return new StaticConfigWatcher(new Config());
        }
        if (args.startsWith("@")) {
            return new FileConfigWatcher(new File(args.substring(1)), listener);
        }
        Config config = MAPPER.readValue(args, Config.class);
        MoreValidators.validate(config);
        return new StaticConfigWatcher(config);
    }

    private static void safeStart(NanoHTTPD server, int timeout, boolean daemon) throws Throwable {
        try {
            server.start(timeout, daemon);
        }
        catch (Throwable th) {
            try {
                server.stop();
            }
            catch (Throwable th2) {
                th.addSuppressed(th2);
            }
            throw th;
        }
    }

    public static void premain(String args) throws Throwable {
        LOG.log(Level.INFO, "Starting Prometheus Metrics Agent...");
        try {
            ConfigWatcher watcher = Agent.newConfigWatcher(args, (oldConfig, newConfig) -> {
                LOG.log(Level.FINE, "Detected configuration change. Reconfiguring Prometheus Metrics Agent...");
                PrometheusExporterServerHandler handler = new PrometheusExporterServerHandler(newConfig.rules, newConfig.labels, newConfig.options);
                if (!oldConfig.server.bindAddress.equals(newConfig.server.bindAddress)) {
                    try {
                        SERVER.stop();
                    }
                    catch (Throwable th) {
                        LOG.log(Level.WARNING, "Failed to stop Prometheus Metrics Agent server for reconfiguration.", th);
                    }
                    SERVER = new PrometheusExporterServer(newConfig.server.bindAddress, handler);
                    Agent.safeStart(SERVER, 5000, true);
                } else {
                    SERVER.configure(handler);
                }
                LOG.log(Level.INFO, "Successfully reconfigured Prometheus Metrics Agent.");
            });
            Config initialConfig = watcher.config();
            PrometheusExporterServerHandler handler = new PrometheusExporterServerHandler(initialConfig.rules, initialConfig.labels, initialConfig.options);
            SERVER = new PrometheusExporterServer(initialConfig.server.bindAddress, handler);
            Agent.safeStart(SERVER, 5000, true);
            watcher.start();
        }
        catch (Throwable th) {
            LOG.log(Level.SEVERE, "Failed to start Prometheus Metrics Agent.", th);
            throw th;
        }
    }
}

