/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.tree;

import java.util.Collections;
import java.util.List;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Scope;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.JsonQueryFunction;

public class FunctionDefinition
extends JsonQuery {
    private JsonQuery body;
    private String fname;
    private List<String> args;

    public FunctionDefinition(String fname, List<String> args, JsonQuery body) {
        this.fname = fname;
        this.args = args;
        this.body = body;
    }

    @Override
    public List<JsonNode> apply(Scope scope, JsonNode in) throws JsonQueryException {
        scope.addFunction(this.fname, this.args.size(), new JsonQueryFunction(this.fname, this.args, this.body, scope));
        return Collections.emptyList();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("def ");
        builder.append(this.fname);
        if (!this.args.isEmpty()) {
            builder.append("(");
            String sep = "";
            for (String arg : this.args) {
                builder.append(sep);
                builder.append(arg);
                sep = "; ";
            }
            builder.append(")");
        }
        builder.append(": ");
        builder.append(this.body);
        return builder.toString();
    }
}

