/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.tree;

import java.util.List;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Function;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Scope;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;

public class FunctionCall
extends JsonQuery {
    private String name;
    private List<JsonQuery> args;

    public FunctionCall(String name, List<JsonQuery> args) {
        this.name = name;
        this.args = args;
    }

    @Override
    public List<JsonNode> apply(Scope scope, JsonNode in) throws JsonQueryException {
        Function f = scope.getFunction(this.name, this.args.size());
        if (f == null) {
            throw new JsonQueryException(String.format("Function %s/%s does not exist", this.name, this.args.size()));
        }
        return f.apply(scope, this.args, in);
    }

    public String toString() {
        if (this.args.isEmpty()) {
            return String.format("%s", this.name);
        }
        StringBuilder builder = new StringBuilder(this.name);
        builder.append("(");
        String sep = "";
        for (JsonQuery arg : this.args) {
            builder.append(sep);
            if (arg == null) {
                builder.append("null");
            } else {
                builder.append(arg.toString());
            }
            sep = "; ";
        }
        builder.append(")");
        return builder.toString();
    }
}

