/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Scope;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryBreakException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.misc.Pair;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.tree.matcher.PatternMatcher;

public class ForeachExpression
extends JsonQuery {
    private JsonQuery iterExpr;
    private JsonQuery updateExpr;
    private JsonQuery initExpr;
    private JsonQuery extractExpr;
    private PatternMatcher matcher;

    public ForeachExpression(PatternMatcher matcher, JsonQuery initExpr, JsonQuery updateExpr, JsonQuery extractExpr, JsonQuery iterExpr) {
        this.matcher = matcher;
        this.initExpr = initExpr;
        this.updateExpr = updateExpr;
        this.extractExpr = extractExpr;
        this.iterExpr = iterExpr;
    }

    @Override
    public List<JsonNode> apply(Scope scope, JsonNode in) throws JsonQueryException {
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        try {
            for (JsonNode accumulator : this.initExpr.apply(scope, in)) {
                JsonNode[] accumulators = new JsonNode[]{accumulator};
                Scope childScope = Scope.newChildScope(scope);
                for (JsonNode item : this.iterExpr.apply(scope, in)) {
                    Stack<Pair<String, JsonNode>> stack = new Stack<Pair<String, JsonNode>>();
                    this.matcher.match(scope, item, vars -> {
                        for (int i = vars.size() - 1; i >= 0; --i) {
                            Pair var = (Pair)vars.get(i);
                            childScope.setValue((String)var._1, (JsonNode)var._2);
                        }
                        for (JsonNode newaccumulator : this.updateExpr.apply(childScope, accumulators[0])) {
                            if (this.extractExpr != null) {
                                for (JsonNode extract : this.extractExpr.apply(childScope, newaccumulator)) {
                                    out.add(extract);
                                }
                            } else {
                                out.add(newaccumulator);
                            }
                            accumulators[0] = newaccumulator;
                        }
                    }, stack, true);
                }
            }
        }
        catch (JsonQueryBreakException jsonQueryBreakException) {
            // empty catch block
        }
        return out;
    }

    public String toString() {
        if (this.extractExpr == null) {
            return String.format("(foreach %s as %s (%s; %s))", this.iterExpr, this.matcher, this.initExpr, this.updateExpr);
        }
        return String.format("(foreach %s as %s (%s; %s; %s))", this.iterExpr, this.matcher, this.initExpr, this.updateExpr, this.extractExpr);
    }
}

