/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.operators;

import java.util.Iterator;
import java.util.Map;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.ObjectMapper;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.NullNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.ObjectNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.TextNode;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryTypeException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.misc.JsonNodeUtils;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.misc.Strings;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.operators.BinaryOperator;

public class MultiplyOperator
implements BinaryOperator {
    @Override
    public JsonNode apply(ObjectMapper mapper, JsonNode lhs, JsonNode rhs) throws JsonQueryException {
        if (lhs.isIntegralNumber() && rhs.isIntegralNumber()) {
            long r = lhs.asLong() * rhs.asLong();
            return JsonNodeUtils.asNumericNode(r);
        }
        if (lhs.isNumber() && rhs.isNumber()) {
            double r = lhs.asDouble() * rhs.asDouble();
            return JsonNodeUtils.asNumericNode(r);
        }
        if (lhs.isTextual() && rhs.canConvertToInt()) {
            int count = rhs.asInt();
            if (count <= 0) {
                return NullNode.getInstance();
            }
            return new TextNode(Strings.repeat(lhs.asText(), count));
        }
        if (lhs.isObject() && rhs.isObject()) {
            return MultiplyOperator.mergeRecursive(mapper, (ObjectNode)lhs, (ObjectNode)rhs);
        }
        throw new JsonQueryTypeException(lhs, rhs, "cannot be multiplied");
    }

    private static ObjectNode mergeRecursive(ObjectMapper mapper, ObjectNode lhs, ObjectNode rhs) {
        ObjectNode result = mapper.createObjectNode();
        Iterator<Map.Entry<String, JsonNode>> liter = lhs.fields();
        while (liter.hasNext()) {
            Map.Entry<String, JsonNode> e = liter.next();
            result.set(e.getKey(), e.getValue());
        }
        Iterator<Map.Entry<String, JsonNode>> riter = rhs.fields();
        while (riter.hasNext()) {
            JsonNode r;
            Map.Entry<String, JsonNode> e = riter.next();
            JsonNode l = result.get(e.getKey());
            JsonNode resolved = r = e.getValue();
            if (l != null && l.isObject() && r.isObject()) {
                resolved = MultiplyOperator.mergeRecursive(mapper, (ObjectNode)l, (ObjectNode)r);
            }
            result.set(e.getKey(), resolved);
        }
        return result;
    }

    @Override
    public String image() {
        return "*";
    }
}

