/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.functions;

import java.util.ArrayList;
import java.util.List;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.TextNode;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Function;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Scope;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryTypeException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.BuiltinFunction;

@BuiltinFunction(value={"join/1"})
public class JoinFunction
implements Function {
    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        for (JsonNode sep : args.get(0).apply(scope, in)) {
            JsonNode isep = null;
            StringBuilder builder = new StringBuilder();
            for (JsonNode item : in) {
                if (isep != null) {
                    if (isep.isTextual()) {
                        builder.append(isep.asText());
                    } else if (!isep.isNull()) {
                        throw new JsonQueryTypeException(new TextNode(builder.toString()), isep, "cannot be added");
                    }
                }
                if (item.isTextual()) {
                    builder.append(item.asText());
                } else if (!item.isNull()) {
                    if (item.isNumber() || item.isBoolean()) {
                        builder.append(item.toString());
                    } else {
                        throw new JsonQueryTypeException(new TextNode(builder.toString()), item, "cannot be added");
                    }
                }
                isep = sep;
            }
            out.add(new TextNode(builder.toString()));
        }
        return out;
    }
}

