/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.extra.functions;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.JsonNodeType;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.LongNode;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Function;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Scope;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.misc.Preconditions;

@BuiltinFunction(value={"strptime/1", "strptime/2"})
public class StrPTimeFunction
implements Function {
    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        Preconditions.checkInputType("strptime", in, JsonNodeType.STRING);
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        try {
            for (JsonNode fmt : args.get(0).apply(in)) {
                if (!fmt.isTextual()) {
                    throw JsonQueryException.format("Illegal argument type: %s", new Object[]{fmt.getNodeType()});
                }
                SimpleDateFormat sdf = new SimpleDateFormat(fmt.asText());
                if (args.size() == 2) {
                    for (JsonNode tz : args.get(1).apply(in)) {
                        if (!tz.isTextual()) {
                            throw JsonQueryException.format("Timezone must be a string", new Object[0]);
                        }
                        sdf.setTimeZone(TimeZone.getTimeZone(tz.asText()));
                        out.add(new LongNode(sdf.parse(in.asText()).getTime()));
                    }
                    continue;
                }
                out.add(new LongNode(sdf.parse(in.asText()).getTime()));
            }
        }
        catch (Exception e) {
            throw new JsonQueryException(e);
        }
        return out;
    }
}

