/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.scraper;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import net.thisptr.java.prometheus.metrics.agent.jackson.JmxModule;
import net.thisptr.java.prometheus.metrics.agent.misc.AttributeNamePattern;
import net.thisptr.java.prometheus.metrics.agent.scraper.ScrapeOutput;
import net.thisptr.java.prometheus.metrics.agent.scraper.ScrapeRule;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.MapperFeature;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.ObjectMapper;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.LongNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.ObjectNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.TextNode;

public class Scraper<ScrapeRuleType extends ScrapeRule> {
    private static final Logger LOG = Logger.getLogger(Scraper.class.getName());
    public static final ObjectMapper JMX_MAPPER = new ObjectMapper().registerModule(new JmxModule()).disable(MapperFeature.AUTO_DETECT_GETTERS).disable(MapperFeature.AUTO_DETECT_FIELDS).disable(MapperFeature.AUTO_DETECT_IS_GETTERS).disable(MapperFeature.AUTO_DETECT_SETTERS).disable(MapperFeature.AUTO_DETECT_CREATORS);
    private final List<ScrapeRuleType> rules;
    private final MBeanServer server;

    public Scraper(MBeanServer server, List<ScrapeRuleType> rules) {
        this.server = server;
        this.rules = rules;
    }

    private ScrapeRuleType findRule(ObjectName name, String attribute) {
        for (ScrapeRule rule : this.rules) {
            if (rule.patterns() == null || rule.patterns().isEmpty()) {
                return (ScrapeRuleType)rule;
            }
            for (AttributeNamePattern pattern : rule.patterns()) {
                if (!pattern.matches(name, attribute)) continue;
                return (ScrapeRuleType)rule;
            }
        }
        return null;
    }

    private void enumerate(BiConsumer<ObjectInstance, MBeanAttributeInfo> output) {
        try {
            for (ObjectInstance instance : this.server.queryMBeans(null, null)) {
                this.enumerate(instance, output);
            }
        }
        catch (Throwable th) {
            LOG.log(Level.FINE, "Failed to enumerate MBean instances.", th);
        }
    }

    private void enumerate(ObjectInstance instance, BiConsumer<ObjectInstance, MBeanAttributeInfo> output) {
        ObjectName name = instance.getObjectName();
        try {
            for (MBeanAttributeInfo attribute : this.server.getMBeanInfo(name).getAttributes()) {
                try {
                    output.accept(instance, attribute);
                }
                catch (Throwable th) {
                    LOG.log(Level.WARNING, "Got unexpected exception from callback (name = " + name + ", attribute = " + attribute.getName() + ").", th);
                }
            }
        }
        catch (Throwable th) {
            LOG.log(Level.FINER, "Failed to enumerate attributes of the MBean instance (name = " + name + ")", th);
        }
    }

    public void scrape(ScrapeOutput<ScrapeRuleType> output) throws InterruptedException {
        this.scrape(output, 0L, TimeUnit.MILLISECONDS);
    }

    public void scrape(ScrapeOutput<ScrapeRuleType> output, long duration, TimeUnit unit) throws InterruptedException {
        ArrayList requests = new ArrayList();
        this.enumerate((instance, attribute) -> {
            ObjectName name = instance.getObjectName();
            if (!attribute.isReadable()) {
                return;
            }
            ScrapeRuleType rule = this.findRule(name, attribute.getName());
            if (rule != null && rule.skip()) {
                return;
            }
            requests.add(new AttributeScrapeRequest(this, instance, attribute, rule));
        });
        long startNanos = System.nanoTime();
        long durationNanos = unit.toNanos(duration);
        for (int i = 0; i < requests.size(); ++i) {
            long waitUntilNanos = startNanos + (long)((double)(i + 1) / (double)requests.size() * (double)durationNanos);
            long sleepNanos = waitUntilNanos - System.nanoTime();
            if (sleepNanos > 0L) {
                Scraper.sleepNanos(sleepNanos);
            }
            AttributeScrapeRequest request = (AttributeScrapeRequest)requests.get(i);
            try {
                this.scrape(request.instance, request.attribute, request.rule, output);
                continue;
            }
            catch (Throwable th) {
                LOG.log(Level.FINER, "Failed to scrape the attribute of the MBean instance (name = " + request.instance.getObjectName() + ", attribute = " + request.attribute.getName() + ")", th);
            }
        }
    }

    private static void sleepNanos(long totalNanos) throws InterruptedException {
        int nanos = (int)(totalNanos % 1000000L);
        long millis = totalNanos / 1000000L;
        Thread.sleep(millis, nanos);
    }

    private void scrape(ObjectInstance instance, MBeanAttributeInfo attribute, ScrapeRuleType rule, ScrapeOutput<ScrapeRuleType> output) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException {
        Object value;
        ObjectName name = instance.getObjectName();
        long timestamp = System.currentTimeMillis();
        try {
            value = this.server.getAttribute(name, attribute.getName());
        }
        catch (RuntimeMBeanException e) {
            if (e.getCause() instanceof UnsupportedOperationException) {
                return;
            }
            throw e;
        }
        Object valueJson = JMX_MAPPER.valueToTree(value);
        ObjectNode out = JMX_MAPPER.createObjectNode();
        out.set("type", TextNode.valueOf(attribute.getType()));
        out.set("value", (JsonNode)valueJson);
        out.set("domain", TextNode.valueOf(name.getDomain()));
        ObjectNode properties = JMX_MAPPER.createObjectNode();
        name.getKeyPropertyList().forEach((k, v) -> {
            if (v.startsWith("\"")) {
                v = ObjectName.unquote(v);
            }
            properties.set((String)k, TextNode.valueOf(v));
        });
        out.set("properties", properties);
        out.set("attribute", TextNode.valueOf(attribute.getName()));
        out.set("timestamp", LongNode.valueOf(timestamp));
        output.emit(rule, timestamp, out);
    }

    private static class AttributeScrapeRequest {
        public final ObjectInstance instance;
        public final MBeanAttributeInfo attribute;
        public final ScrapeRuleType rule;
        final /* synthetic */ Scraper this$0;

        public AttributeScrapeRequest(ObjectInstance instance, MBeanAttributeInfo attribute, ScrapeRuleType rule) {
            this.this$0 = var1_1;
            this.instance = instance;
            this.attribute = attribute;
            this.rule = rule;
        }
    }
}

