/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import net.thisptr.java.prometheus.metrics.agent.PrometheusMetric;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.TextNode;

public class PrometheusMetricWriter
implements Closeable {
    private final Writer writer;
    private final boolean includeTimestamp;

    public PrometheusMetricWriter(Writer writer, boolean includeTimestamp) {
        this.writer = writer;
        this.includeTimestamp = includeTimestamp;
    }

    private static String sanitizeMetricName(String name) {
        if (name.isEmpty()) {
            return "_";
        }
        char[] chars = name.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            boolean valid;
            char ch = chars[i];
            boolean bl = valid = 'a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9' && i != 0 || ch == '_' || ch == ':';
            if (valid) continue;
            chars[i] = 95;
        }
        return new String(chars);
    }

    private static String sanitizeLabelName(String name) {
        if (name.isEmpty()) {
            return "_";
        }
        char[] chars = name.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            boolean valid;
            char ch = chars[i];
            boolean bl = valid = 'a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9' && i != 0 || ch == '_';
            if (valid) continue;
            chars[i] = 95;
        }
        return new String(chars);
    }

    public void write(PrometheusMetric metric) throws IOException {
        this.writer.write(PrometheusMetricWriter.sanitizeMetricName(metric.name));
        if (!metric.labels.isEmpty()) {
            this.writer.write(123);
            for (Map.Entry<String, String> entry : metric.labels.entrySet()) {
                this.writer.write(PrometheusMetricWriter.sanitizeLabelName(entry.getKey()));
                this.writer.write(61);
                this.writer.write(TextNode.valueOf(entry.getValue()).toString());
                this.writer.write(44);
            }
            this.writer.write(125);
        }
        this.writer.write(32);
        this.writer.write(String.valueOf(metric.value));
        if (this.includeTimestamp && metric.timestamp != null) {
            this.writer.write(32);
            this.writer.write(String.valueOf(metric.timestamp));
        }
        this.writer.write(10);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

