/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.misc.jq;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import net.thisptr.java.prometheus.metrics.agent.scraper.Scraper;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.NullNode;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Function;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Scope;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;

public class JmxFunction
implements Function {
    private static JsonNode get(MBeanServer server, String name, String attribute) throws InstanceNotFoundException, ReflectionException, MBeanException, MalformedObjectNameException, AttributeNotFoundException {
        AttributeNotFoundException th = null;
        for (ObjectName on : server.queryNames(new ObjectName(name), null)) {
            try {
                Object value = server.getAttribute(on, attribute);
                return Scraper.JMX_MAPPER.valueToTree(value);
            }
            catch (AttributeNotFoundException e) {
                th = e;
            }
        }
        if (th != null) {
            throw th;
        }
        throw new InstanceNotFoundException(name);
    }

    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        JsonQuery nameExpr = args.get(0);
        JsonQuery attributeExpr = args.get(1);
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        for (JsonNode name : nameExpr.apply(scope, NullNode.getInstance())) {
            if (!name.isTextual()) {
                throw new JsonQueryException("objectname must be string");
            }
            for (JsonNode attribute : attributeExpr.apply(scope, NullNode.getInstance())) {
                if (!attribute.isTextual()) {
                    throw new JsonQueryException("attribute must be string");
                }
                try {
                    out.add(JmxFunction.get(server, name.asText(), attribute.asText()));
                }
                catch (Exception e) {
                    throw new JsonQueryException(e);
                }
            }
        }
        return out;
    }
}

