/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.org.hibernate.validator.internal.metadata.location;

import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import net.thisptr.java.prometheus.metrics.agent.shade.org.hibernate.validator.internal.engine.path.PathImpl;
import net.thisptr.java.prometheus.metrics.agent.shade.org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import net.thisptr.java.prometheus.metrics.agent.shade.org.hibernate.validator.internal.util.ExecutableParameterNameProvider;

class CrossParameterConstraintLocation
implements ConstraintLocation {
    private final Executable executable;

    CrossParameterConstraintLocation(Executable executable) {
        this.executable = executable;
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.executable.getDeclaringClass();
    }

    @Override
    public Member getMember() {
        return this.executable;
    }

    @Override
    public Type getTypeForValidatorResolution() {
        return Object[].class;
    }

    @Override
    public void appendTo(ExecutableParameterNameProvider parameterNameProvider, PathImpl path) {
        path.addCrossParameterNode();
    }

    @Override
    public Object getValue(Object parent) {
        return parent;
    }

    public String toString() {
        return "CrossParameterConstraintLocation [executable=" + this.executable + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.executable == null ? 0 : this.executable.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CrossParameterConstraintLocation other = (CrossParameterConstraintLocation)obj;
        return !(this.executable == null ? other.executable != null : !this.executable.equals(other.executable));
    }
}

