/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.org.hibernate.validator.internal.constraintvalidators.hv;

import java.lang.invoke.MethodHandles;
import net.thisptr.java.prometheus.metrics.agent.shade.javax.validation.ConstraintValidator;
import net.thisptr.java.prometheus.metrics.agent.shade.javax.validation.ConstraintValidatorContext;
import net.thisptr.java.prometheus.metrics.agent.shade.org.hibernate.validator.constraints.CodePointLength;
import net.thisptr.java.prometheus.metrics.agent.shade.org.hibernate.validator.internal.util.logging.Log;
import net.thisptr.java.prometheus.metrics.agent.shade.org.hibernate.validator.internal.util.logging.LoggerFactory;

public class CodePointLengthValidator
implements ConstraintValidator<CodePointLength, CharSequence> {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private int min;
    private int max;
    private CodePointLength.NormalizationStrategy normalizationStrategy;

    @Override
    public void initialize(CodePointLength parameters) {
        this.min = parameters.min();
        this.max = parameters.max();
        this.normalizationStrategy = parameters.normalizationStrategy();
        this.validateParameters();
    }

    @Override
    public boolean isValid(CharSequence value, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null) {
            return true;
        }
        String stringValue = this.normalizationStrategy.normalize(value).toString();
        int length = stringValue.codePointCount(0, stringValue.length());
        return length >= this.min && length <= this.max;
    }

    private void validateParameters() {
        if (this.min < 0) {
            throw LOG.getMinCannotBeNegativeException();
        }
        if (this.max < 0) {
            throw LOG.getMaxCannotBeNegativeException();
        }
        if (this.max < this.min) {
            throw LOG.getLengthCannotBeNegativeException();
        }
    }
}

