/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.org.hibernate.validator.internal.constraintvalidators.bv.money;

import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import javax.money.MonetaryAmount;
import net.thisptr.java.prometheus.metrics.agent.shade.javax.validation.ConstraintValidator;
import net.thisptr.java.prometheus.metrics.agent.shade.javax.validation.ConstraintValidatorContext;
import net.thisptr.java.prometheus.metrics.agent.shade.javax.validation.constraints.DecimalMax;
import net.thisptr.java.prometheus.metrics.agent.shade.org.hibernate.validator.internal.util.logging.Log;
import net.thisptr.java.prometheus.metrics.agent.shade.org.hibernate.validator.internal.util.logging.LoggerFactory;

public class DecimalMaxValidatorForMonetaryAmount
implements ConstraintValidator<DecimalMax, MonetaryAmount> {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private BigDecimal maxValue;
    private boolean inclusive;

    @Override
    public void initialize(DecimalMax maxValue) {
        try {
            this.maxValue = new BigDecimal(maxValue.value());
        }
        catch (NumberFormatException nfe) {
            throw LOG.getInvalidBigDecimalFormatException(maxValue.value(), nfe);
        }
        this.inclusive = maxValue.inclusive();
    }

    @Override
    public boolean isValid(MonetaryAmount value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        int comparisonResult = ((BigDecimal)value.getNumber().numberValueExact(BigDecimal.class)).compareTo(this.maxValue);
        return this.inclusive ? comparisonResult <= 0 : comparisonResult < 0;
    }
}

