/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.tree.matcher.matchers;

import java.util.List;
import java.util.Stack;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.NullNode;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Scope;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryTypeException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.misc.Functional;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.misc.Pair;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.tree.matcher.PatternMatcher;

public class ArrayMatcher
implements PatternMatcher {
    private List<PatternMatcher> matchers;

    public ArrayMatcher(List<PatternMatcher> matchers) {
        this.matchers = matchers;
    }

    @Override
    public void match(Scope scope, JsonNode in, Functional.Consumer<List<Pair<String, JsonNode>>> out, Stack<Pair<String, JsonNode>> accumulate, boolean emit) throws JsonQueryException {
        if (!in.isArray() && !in.isNull()) {
            throw JsonQueryTypeException.format("Cannot index %s with number", new Object[]{in.getNodeType()});
        }
        for (int i = 0; i < this.matchers.size(); ++i) {
            PatternMatcher matcher = this.matchers.get(i);
            JsonNode item = in.get(i);
            matcher.match(scope, item != null ? item : NullNode.getInstance(), out, accumulate, emit && i == this.matchers.size() - 1);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        String sep = "";
        for (PatternMatcher matcher : this.matchers) {
            sb.append(sep);
            sb.append(matcher);
            sep = ", ";
        }
        sb.append("]");
        return sb.toString();
    }
}

