/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.operators;

import java.util.regex.Pattern;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.ObjectMapper;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.ArrayNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.TextNode;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryTypeException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.misc.JsonNodeUtils;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.operators.BinaryOperator;

public class DivideOperator
implements BinaryOperator {
    @Override
    public JsonNode apply(ObjectMapper mapper, JsonNode lhs, JsonNode rhs) throws JsonQueryException {
        if (lhs.isNumber() && rhs.isNumber()) {
            double divisor = rhs.asDouble();
            double dividend = lhs.asDouble();
            if (divisor == 0.0) {
                throw JsonQueryException.format("number (%s) and number (%s) cannot be divided because the divisor is zero", dividend, divisor);
            }
            return JsonNodeUtils.asNumericNode(dividend / divisor);
        }
        if (lhs.isTextual() && rhs.isTextual()) {
            ArrayNode result = mapper.createArrayNode();
            for (String token : lhs.asText().split(Pattern.quote(rhs.asText()))) {
                result.add(new TextNode(token));
            }
            return result;
        }
        throw new JsonQueryTypeException(lhs, rhs, "cannot be divided");
    }

    @Override
    public String image() {
        return "/";
    }
}

