/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.functions;

import java.util.ArrayList;
import java.util.List;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Function;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Scope;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.misc.JsonNodeUtils;

@BuiltinFunction(value={"range/3"})
public class RangeFunction
implements Function {
    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        List<JsonNode> beginTuple = args.get(0).apply(scope, in);
        List<JsonNode> endTuple = args.get(1).apply(scope, in);
        List<JsonNode> incTuple = args.get(2).apply(scope, in);
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        for (JsonNode beginNode : beginTuple) {
            for (JsonNode endNode : endTuple) {
                for (JsonNode incNode : incTuple) {
                    double i;
                    if (!(beginNode.isNumber() && endNode.isNumber() && incNode.isNumber())) {
                        throw new JsonQueryException("arguments of range() must be NUMBER");
                    }
                    double begin = beginNode.asDouble();
                    double end = endNode.asDouble();
                    double inc = incNode.asDouble();
                    if (inc > 0.0) {
                        for (i = begin; i < end; i += inc) {
                            out.add(JsonNodeUtils.asNumericNode(i));
                        }
                        continue;
                    }
                    if (!(inc < 0.0)) continue;
                    for (i = begin; i > end; i += inc) {
                        out.add(JsonNodeUtils.asNumericNode(i));
                    }
                }
            }
        }
        return out;
    }
}

