/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.functions;

import java.util.ArrayList;
import java.util.List;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.IntNode;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Function;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Scope;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.misc.JsonNodeUtils;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.misc.UnicodeUtils;

@BuiltinFunction(value={"length/0"})
public class LengthFunction
implements Function {
    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        out.add(this.length(in));
        return out;
    }

    public JsonNode length(JsonNode in) throws JsonQueryException {
        if (in.isTextual()) {
            return IntNode.valueOf(UnicodeUtils.lengthUtf32(in.asText()));
        }
        if (in.isArray() || in.isObject()) {
            return new IntNode(in.size());
        }
        if (in.isNull()) {
            return new IntNode(0);
        }
        if (in.isNumber()) {
            return JsonNodeUtils.asNumericNode(Math.abs(in.asDouble()));
        }
        throw JsonQueryException.format("%s has no length", new Object[]{in.getNodeType()});
    }
}

