/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.extra.functions;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.NullNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.TextNode;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Function;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Scope;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.BuiltinFunction;

@BuiltinFunction(value={"hostname/0", "hostname/1"})
public class HostnameFunction
implements Function {
    private JsonNode hostname = NullNode.getInstance();
    private JsonNode fqdn = NullNode.getInstance();

    public HostnameFunction() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            this.hostname = new TextNode(addr.getHostName());
            this.fqdn = new TextNode(addr.getCanonicalHostName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        if (args.size() == 1) {
            ArrayList<JsonNode> out = new ArrayList<JsonNode>();
            for (JsonNode arg : args.get(0).apply(in)) {
                if (arg.isTextual() && "fqdn".equals(arg.asText())) {
                    out.add(this.fqdn);
                    continue;
                }
                out.add(this.hostname);
            }
            return out;
        }
        return Collections.singletonList(this.hostname);
    }
}

