/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.TreeMap;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.annotation.JsonIgnore;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.annotation.JsonProperty;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.MappingIterator;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.ObjectMapper;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Function;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.JsonQueryFunction;

public class Scope {
    private static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper();
    @JsonProperty(value="parent")
    private Scope parentScope;
    @JsonIgnore
    private Map<String, Function> functions = new HashMap<String, Function>();
    @JsonProperty(value="variables")
    private Map<String, JsonNode> values = new HashMap<String, JsonNode>();
    @JsonIgnore
    private ObjectMapper mapper = DEFAULT_MAPPER;

    @JsonProperty(value="functions")
    private Map<String, String> debugFunctions() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Map.Entry<String, Function> f : this.functions.entrySet()) {
            result.put(f.getKey(), f.getValue().toString());
        }
        return result;
    }

    @Deprecated
    public Scope() {
        this(RootScopeHolder.INSTANCE);
    }

    @Deprecated
    public Scope(Scope parentScope) {
        this.parentScope = parentScope;
    }

    public static Scope newEmptyScope() {
        return new Scope(null);
    }

    public static Scope newChildScope(Scope scope) {
        return new Scope(scope);
    }

    public void addFunction(String name, int n, Function q) {
        this.functions.put(name + "/" + n, q);
    }

    public void addFunction(String name, Function q) {
        this.functions.put(name, q);
    }

    public Function getFunction(String name, int nargs) {
        Function f = this.getFunctionRecursive(name, nargs);
        if (f != null) {
            return f;
        }
        return this.getFunctionRecursive(name);
    }

    private Function getFunctionRecursive(String name, int nargs) {
        Function q = this.functions.get(name + "/" + nargs);
        if (q == null && this.parentScope != null) {
            return this.parentScope.getFunctionRecursive(name, nargs);
        }
        return q;
    }

    private Function getFunctionRecursive(String name) {
        Function q = this.functions.get(name);
        if (q == null && this.parentScope != null) {
            return this.parentScope.getFunctionRecursive(name);
        }
        return q;
    }

    public void setValue(String name, JsonNode value) {
        this.values.put(name, value);
    }

    public JsonNode getValue(String name) {
        JsonNode value = this.values.get(name);
        if (value == null && this.parentScope != null) {
            return this.parentScope.getValue(name);
        }
        return value;
    }

    @JsonIgnore
    public ObjectMapper getObjectMapper() {
        return this.mapper;
    }

    @Deprecated
    public static Scope rootScope() {
        return RootScopeHolder.INSTANCE;
    }

    private static final String resolvePath(Class<?> clazz, String name) {
        String base = clazz.getName();
        return base.substring(0, base.lastIndexOf(46)).replace('.', '/') + '/' + name;
    }

    public void loadFunctions(ClassLoader classLoader) {
        this.loadMacros(classLoader, Scope.resolvePath(Scope.class, "jq.json"));
        this.loadBuiltinFunctions(classLoader);
    }

    private static List<JqJson> loadConfig(ClassLoader loader, String path) throws IOException {
        ArrayList<JqJson> result = new ArrayList<JqJson>();
        Enumeration<URL> iter = loader.getResources(path);
        while (iter.hasMoreElements()) {
            InputStream is = iter.nextElement().openStream();
            Throwable throwable = null;
            try {
                Iterator iter2 = DEFAULT_MAPPER.readValues(DEFAULT_MAPPER.getFactory().createParser(is), JqJson.class);
                while (((MappingIterator)iter2).hasNext()) {
                    result.add((JqJson)((MappingIterator)iter2).next());
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
        return result;
    }

    private void loadBuiltinFunctions(ClassLoader classLoader) {
        for (Function fn : ServiceLoader.load(Function.class, classLoader)) {
            BuiltinFunction annotation = fn.getClass().getAnnotation(BuiltinFunction.class);
            if (annotation == null) continue;
            for (String name : annotation.value()) {
                this.addFunction(name, fn);
            }
        }
    }

    private void loadMacros(ClassLoader classLoader, String path) {
        try {
            List<JqJson> configs = Scope.loadConfig(classLoader, path);
            for (JqJson jqJson : configs) {
                for (JqJson.JqFuncDef def : jqJson.functions) {
                    this.addFunction(def.name, def.args.size(), new JsonQueryFunction(def.name, def.args, JsonQuery.compile(def.body), this));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load macros", e);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class JqJson {
        @JsonProperty(value="functions")
        public List<JqFuncDef> functions = new ArrayList<JqFuncDef>();

        private JqJson() {
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class JqFuncDef {
            @JsonProperty(value="name")
            public String name;
            @JsonProperty(value="args")
            public List<String> args = new ArrayList<String>();
            @JsonProperty(value="body")
            public String body;
        }
    }

    @BuiltinFunction(value={"debug_scope/0"})
    public static class DebugScopeFunction
    implements Function {
        @Override
        public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
            HashMap<String, Object> info = new HashMap<String, Object>();
            info.put("scope", scope);
            info.put("input", in);
            return Collections.singletonList(DEFAULT_MAPPER.valueToTree(info));
        }
    }

    @Deprecated
    private static final class RootScopeHolder {
        @Deprecated
        public static final Scope INSTANCE = new Scope(null);

        private RootScopeHolder() {
        }

        static {
            try {
                ClassLoader classLoader = Optional.ofNullable(Thread.currentThread().getContextClassLoader()).orElse(Scope.class.getClassLoader());
                INSTANCE.loadFunctions(classLoader);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to instantiate default Scope object", e);
            }
        }
    }
}

