/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent;

import java.io.IOException;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.ReflectionException;
import net.thisptr.java.prometheus.metrics.agent.PrometheusExporterServer;
import net.thisptr.java.prometheus.metrics.agent.PrometheusMetric;
import net.thisptr.java.prometheus.metrics.agent.PrometheusMetricWriter;
import net.thisptr.java.prometheus.metrics.agent.PrometheusScrapeOutput;
import net.thisptr.java.prometheus.metrics.agent.RootScope;
import net.thisptr.java.prometheus.metrics.agent.config.Config;
import net.thisptr.java.prometheus.metrics.agent.scraper.Scraper;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.core.JsonParser;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.core.type.TypeReference;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.ObjectMapper;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.NullNode;
import net.thisptr.java.prometheus.metrics.agent.shade.fi.iki.elonen.NanoHTTPD;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.JsonQuery;

public class PrometheusExporterServerHandler {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final Scraper<Config.PrometheusScrapeRule> scraper;
    private final JsonQuery labels;

    public PrometheusExporterServerHandler(List<Config.PrometheusScrapeRule> rules, JsonQuery labels) {
        this.labels = labels;
        this.scraper = new Scraper<Config.PrometheusScrapeRule>(ManagementFactory.getPlatformMBeanServer(), rules);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> makeLabels() throws IOException {
        if (this.labels == null) {
            return Collections.emptyMap();
        }
        List<JsonNode> nodes = this.labels.apply(RootScope.getInstance(), NullNode.getInstance());
        if (nodes.isEmpty()) {
            return Collections.emptyMap();
        }
        JsonNode in = nodes.get(nodes.size() - 1);
        try (JsonParser jp = MAPPER.treeAsTokens(in);){
            Map map = (Map)MAPPER.readValue(jp, new TypeReference<Map<String, String>>(){});
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot deserialize labels from input: " + in, e);
        }
    }

    public NanoHTTPD.Response handleGetMetrics() throws IntrospectionException, InstanceNotFoundException, ReflectionException, IOException {
        Map<String, String> labels = this.makeLabels();
        TreeMap<String, List> allMetrics = new TreeMap<String, List>();
        this.scraper.scrape(new PrometheusScrapeOutput(RootScope.getInstance(), metric -> {
            if (metric.labels == null) {
                metric.labels = new HashMap<String, String>();
            }
            metric.labels.putAll(labels);
            allMetrics.computeIfAbsent(metric.name, name -> new ArrayList()).add(metric);
        }));
        StringWriter writer = new StringWriter();
        try (PrometheusMetricWriter pwriter = new PrometheusMetricWriter(writer);){
            allMetrics.forEach((name, metrics) -> metrics.forEach(metric -> {
                try {
                    pwriter.write((PrometheusMetric)metric);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }));
        }
        return PrometheusExporterServer.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, "text/plain; version=0.0.4; charset=utf-8", writer.toString());
    }

    public NanoHTTPD.Response handleGetMBeans() throws IntrospectionException, InstanceNotFoundException, ReflectionException, IOException {
        StringWriter writer = new StringWriter();
        this.scraper.scrape((rule, value) -> {
            writer.write(value.toString());
            writer.write(10);
        });
        return PrometheusExporterServer.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, "text/plain; charset=utf-8", writer.toString());
    }

    public NanoHTTPD.Response handleGetMetricsRaw() throws IntrospectionException, InstanceNotFoundException, ReflectionException, IOException {
        StringWriter writer = new StringWriter();
        this.scraper.scrape(new PrometheusScrapeOutput(RootScope.getInstance(), metric -> {}, raw -> {
            writer.write(raw.toString());
            writer.write(10);
        }));
        return PrometheusExporterServer.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, "text/plain; charset=utf-8", writer.toString());
    }
}

