/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.thisptr.java.prometheus.metrics.agent.PrometheusExporterServerHandler;
import net.thisptr.java.prometheus.metrics.agent.shade.com.google.common.net.HostAndPort;
import net.thisptr.java.prometheus.metrics.agent.shade.fi.iki.elonen.NanoHTTPD;

public class PrometheusExporterServer
extends NanoHTTPD {
    private static final Logger LOG = Logger.getLogger(PrometheusExporterServer.class.getName());
    private volatile PrometheusExporterServerHandler handler;

    public PrometheusExporterServer(HostAndPort bindAddress, PrometheusExporterServerHandler handler) {
        super(bindAddress.getHost(), bindAddress.getPortOrDefault(18090));
        this.handler = handler;
    }

    private NanoHTTPD.Response dispatch(NanoHTTPD.IHTTPSession session) {
        try {
            switch (session.getUri()) {
                case "/metrics": {
                    if (session.getMethod() != NanoHTTPD.Method.GET) {
                        return PrometheusExporterServer.handleMethodNotAllowed();
                    }
                    return this.handler.handleGetMetrics();
                }
                case "/mbeans": {
                    if (session.getMethod() != NanoHTTPD.Method.GET) {
                        return PrometheusExporterServer.handleMethodNotAllowed();
                    }
                    return this.handler.handleGetMBeans();
                }
                case "/metrics-raw": {
                    if (session.getMethod() != NanoHTTPD.Method.GET) {
                        return PrometheusExporterServer.handleMethodNotAllowed();
                    }
                    return this.handler.handleGetMetricsRaw();
                }
            }
        }
        catch (Throwable th) {
            return PrometheusExporterServer.handleInternalError(th);
        }
        return PrometheusExporterServer.handleNotFound();
    }

    private static NanoHTTPD.Response handleMethodNotAllowed() {
        return PrometheusExporterServer.newFixedLengthResponse(NanoHTTPD.Response.Status.METHOD_NOT_ALLOWED, null, null);
    }

    private static NanoHTTPD.Response handleNotFound() {
        return PrometheusExporterServer.newFixedLengthResponse(NanoHTTPD.Response.Status.NOT_FOUND, null, null);
    }

    private static NanoHTTPD.Response handleInternalError(Throwable th) {
        StringWriter writer = new StringWriter();
        try (PrintWriter pwriter = new PrintWriter(writer);){
            th.printStackTrace(pwriter);
        }
        return PrometheusExporterServer.newFixedLengthResponse(NanoHTTPD.Response.Status.INTERNAL_ERROR, "text/plain", writer.toString());
    }

    @Override
    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        NanoHTTPD.Response response = this.dispatch(session);
        LOG.log(Level.FINE, session.getRemoteIpAddress() + " " + (Object)((Object)session.getMethod()) + " " + session.getUri() + " " + response.getStatus().getRequestStatus());
        return response;
    }

    public void configure(PrometheusExporterServerHandler handler) {
        this.handler = handler;
    }
}

