/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.org.joni;

import java.util.IllegalFormatConversionException;
import java.util.Iterator;
import net.thisptr.java.prometheus.metrics.agent.shade.org.jcodings.Encoding;
import net.thisptr.java.prometheus.metrics.agent.shade.org.jcodings.specific.ASCIIEncoding;
import net.thisptr.java.prometheus.metrics.agent.shade.org.jcodings.specific.UTF8Encoding;
import net.thisptr.java.prometheus.metrics.agent.shade.org.jcodings.util.BytesHash;
import net.thisptr.java.prometheus.metrics.agent.shade.org.joni.Analyser;
import net.thisptr.java.prometheus.metrics.agent.shade.org.joni.Matcher;
import net.thisptr.java.prometheus.metrics.agent.shade.org.joni.MatcherFactory;
import net.thisptr.java.prometheus.metrics.agent.shade.org.joni.MinMaxLen;
import net.thisptr.java.prometheus.metrics.agent.shade.org.joni.NameEntry;
import net.thisptr.java.prometheus.metrics.agent.shade.org.joni.OptAnchorInfo;
import net.thisptr.java.prometheus.metrics.agent.shade.org.joni.OptExactInfo;
import net.thisptr.java.prometheus.metrics.agent.shade.org.joni.OptMapInfo;
import net.thisptr.java.prometheus.metrics.agent.shade.org.joni.Option;
import net.thisptr.java.prometheus.metrics.agent.shade.org.joni.Region;
import net.thisptr.java.prometheus.metrics.agent.shade.org.joni.ScanEnvironment;
import net.thisptr.java.prometheus.metrics.agent.shade.org.joni.SearchAlgorithm;
import net.thisptr.java.prometheus.metrics.agent.shade.org.joni.Syntax;
import net.thisptr.java.prometheus.metrics.agent.shade.org.joni.WarnCallback;
import net.thisptr.java.prometheus.metrics.agent.shade.org.joni.exception.InternalException;
import net.thisptr.java.prometheus.metrics.agent.shade.org.joni.exception.ValueException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Regex {
    int[] code;
    int codeLength;
    boolean requireStack;
    Object[] operands;
    int operandLength;
    int numMem;
    int numRepeat;
    int numNullCheck;
    int numCombExpCheck;
    int numCall;
    int captureHistory;
    int btMemStart;
    int btMemEnd;
    int stackPopLevel;
    int[] repeatRangeLo;
    int[] repeatRangeHi;
    public WarnCallback warnings;
    public MatcherFactory factory;
    final Encoding enc;
    int options;
    int userOptions;
    Object userObject;
    final int caseFoldFlag;
    BytesHash<NameEntry> nameTable;
    SearchAlgorithm searchAlgorithm;
    int thresholdLength;
    int anchor;
    int anchorDmin;
    int anchorDmax;
    int subAnchor;
    byte[] exact;
    int exactP;
    int exactEnd;
    byte[] map;
    int[] intMap;
    int[] intMapBackward;
    int dMin;
    int dMax;
    byte[][] templates;
    int templateNum;

    public Regex(CharSequence cs) {
        this(cs.toString());
    }

    public Regex(CharSequence cs, Encoding enc) {
        this(cs.toString(), enc);
    }

    public Regex(String str) {
        this(str.getBytes(), 0, str.length(), 0, UTF8Encoding.INSTANCE);
    }

    public Regex(String str, Encoding enc) {
        this(str.getBytes(), 0, str.length(), 0, enc);
    }

    public Regex(byte[] bytes) {
        this(bytes, 0, bytes.length, 0, ASCIIEncoding.INSTANCE);
    }

    public Regex(byte[] bytes, int p, int end) {
        this(bytes, p, end, 0, ASCIIEncoding.INSTANCE);
    }

    public Regex(byte[] bytes, int p, int end, int option) {
        this(bytes, p, end, option, ASCIIEncoding.INSTANCE);
    }

    public Regex(byte[] bytes, int p, int end, int option, Encoding enc) {
        this(bytes, p, end, option, enc, Syntax.RUBY, WarnCallback.DEFAULT);
    }

    public Regex(byte[] bytes, int p, int end, int option, Encoding enc, Syntax syntax) {
        this(bytes, p, end, option, 0x40000000, enc, syntax, WarnCallback.DEFAULT);
    }

    public Regex(byte[] bytes, int p, int end, int option, Encoding enc, WarnCallback warnings) {
        this(bytes, p, end, option, enc, Syntax.RUBY, warnings);
    }

    public Regex(byte[] bytes, int p, int end, int option, Encoding enc, Syntax syntax, WarnCallback warnings) {
        this(bytes, p, end, option, 0x40000000, enc, syntax, warnings);
    }

    public Regex(byte[] bytes, int p, int end, int option, int caseFoldFlag, Encoding enc, Syntax syntax, WarnCallback warnings) {
        if ((option & 0x180) == 384) {
            throw new ValueException("invalid combination of options");
        }
        if ((option & 0x40) != 0) {
            option |= syntax.options;
            option &= 0xFFFFFFF7;
        } else {
            option |= syntax.options;
        }
        this.enc = enc;
        this.options = option;
        this.caseFoldFlag = caseFoldFlag;
        this.warnings = warnings;
        new Analyser(new ScanEnvironment(this, syntax), bytes, p, end).compile();
        this.warnings = null;
    }

    public Matcher matcher(byte[] bytes) {
        return this.matcher(bytes, 0, bytes.length);
    }

    public Matcher matcher(byte[] bytes, int p, int end) {
        return this.factory.create(this, bytes, p, end);
    }

    public int numberOfCaptures() {
        return this.numMem;
    }

    public int numberOfCaptureHistories() {
        return 0;
    }

    String nameTableToString() {
        StringBuilder sb = new StringBuilder();
        if (this.nameTable != null) {
            sb.append("name table\n");
            for (NameEntry ne : this.nameTable) {
                sb.append("  " + ne + "\n");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    NameEntry nameFind(byte[] name, int nameP, int nameEnd) {
        if (this.nameTable != null) {
            return this.nameTable.get(name, nameP, nameEnd);
        }
        return null;
    }

    void renumberNameTable(int[] map) {
        if (this.nameTable != null) {
            for (NameEntry e : this.nameTable) {
                if (e.backNum > 1) {
                    for (int i = 0; i < e.backNum; ++i) {
                        e.backRefs[i] = map[e.backRefs[i]];
                    }
                    continue;
                }
                if (e.backNum != 1) continue;
                e.backRef1 = map[e.backRef1];
            }
        }
    }

    public int numberOfNames() {
        return this.nameTable == null ? 0 : this.nameTable.size();
    }

    void nameAdd(byte[] name, int nameP, int nameEnd, int backRef, Syntax syntax) {
        if (nameEnd - nameP <= 0) {
            throw new ValueException("group name is empty");
        }
        NameEntry e = null;
        if (this.nameTable == null) {
            this.nameTable = new BytesHash();
        } else {
            e = this.nameFind(name, nameP, nameEnd);
        }
        if (e == null) {
            e = new NameEntry(name, nameP, nameEnd);
            this.nameTable.putDirect(name, nameP, nameEnd, e);
        } else if (e.backNum >= 1 && !syntax.allowMultiplexDefinitionName()) {
            throw new ValueException("multiplex defined name <%n>", new String(name, nameP, nameEnd - nameP));
        }
        e.addBackref(backRef);
    }

    NameEntry nameToGroupNumbers(byte[] name, int nameP, int nameEnd) {
        return this.nameFind(name, nameP, nameEnd);
    }

    public int nameToBackrefNumber(byte[] name, int nameP, int nameEnd, Region region) {
        NameEntry e = this.nameToGroupNumbers(name, nameP, nameEnd);
        if (e == null) {
            throw new ValueException("undefined name <%n> reference", new String(name, nameP, nameEnd - nameP));
        }
        switch (e.backNum) {
            case 0: {
                throw new InternalException("internal parser error (bug)");
            }
            case 1: {
                return e.backRef1;
            }
        }
        if (region != null) {
            for (int i = e.backNum - 1; i >= 0; --i) {
                if (region.beg[e.backRefs[i]] == -1) continue;
                return e.backRefs[i];
            }
        }
        return e.backRefs[e.backNum - 1];
    }

    public Iterator<NameEntry> namedBackrefIterator() {
        return this.nameTable.iterator();
    }

    public boolean noNameGroupIsActive(Syntax syntax) {
        if (Option.isDontCaptureGroup(this.options)) {
            return false;
        }
        return this.numberOfNames() <= 0 || !syntax.captureOnlyNamedGroup() || Option.isCaptureGroup(this.options);
    }

    void setupBMSkipMap() {
        byte[] bytes = this.exact;
        int end = this.exactEnd;
        int p = this.exactP;
        int len = end - p;
        if (len < 256) {
            int i;
            if (this.map == null) {
                this.map = new byte[256];
            }
            for (i = 0; i < 256; ++i) {
                this.map[i] = (byte)len;
            }
            for (i = 0; i < len - 1; ++i) {
                this.map[bytes[p + i] & 0xFF] = (byte)(len - 1 - i);
            }
        } else {
            if (this.intMap == null) {
                this.intMap = new int[256];
            }
            for (int i = 0; i < len - 1; ++i) {
                this.intMap[bytes[p + i] & 0xFF] = len - 1 - i;
            }
        }
    }

    void setExactInfo(OptExactInfo e) {
        if (e.length == 0) {
            return;
        }
        this.exact = e.bytes;
        this.exactP = 0;
        this.exactEnd = e.length;
        if (e.ignoreCase) {
            this.searchAlgorithm = this.enc.toLowerCaseTable() != null ? SearchAlgorithm.SLOW_IC_SB : SearchAlgorithm.SLOW_IC;
        } else {
            boolean allowReverse = this.enc.isReverseMatchAllowed(this.exact, this.exactP, this.exactEnd);
            if (e.length >= 3 || e.length >= 2 && allowReverse) {
                this.setupBMSkipMap();
                this.searchAlgorithm = allowReverse ? SearchAlgorithm.BM : SearchAlgorithm.BM_NOT_REV;
            } else {
                this.searchAlgorithm = this.enc.isSingleByte() ? SearchAlgorithm.SLOW_SB : SearchAlgorithm.SLOW;
            }
        }
        this.dMin = e.mmd.min;
        this.dMax = e.mmd.max;
        if (this.dMin != Integer.MAX_VALUE) {
            this.thresholdLength = this.dMin + (this.exactEnd - this.exactP);
        }
    }

    void setOptimizeMapInfo(OptMapInfo m3) {
        this.map = m3.map;
        this.searchAlgorithm = this.enc.isSingleByte() ? SearchAlgorithm.MAP_SB : SearchAlgorithm.MAP;
        this.dMin = m3.mmd.min;
        this.dMax = m3.mmd.max;
        if (this.dMin != Integer.MAX_VALUE) {
            this.thresholdLength = this.dMin + 1;
        }
    }

    void setSubAnchor(OptAnchorInfo anc) {
        this.subAnchor |= anc.leftAnchor & 2;
        this.subAnchor |= anc.rightAnchor & 0x20;
    }

    void clearOptimizeInfo() {
        this.searchAlgorithm = SearchAlgorithm.NONE;
        this.anchor = 0;
        this.anchorDmax = 0;
        this.anchorDmin = 0;
        this.subAnchor = 0;
        this.exact = null;
        this.exactEnd = 0;
        this.exactP = 0;
    }

    public String encStringToString(byte[] bytes, int p, int end) {
        StringBuilder sb = new StringBuilder("\nPATTERN: /");
        if (this.enc.minLength() > 1) {
            for (int p_ = p; p_ < end; p_ += this.enc.length(bytes, p_, end)) {
                int code = this.enc.mbcToCode(bytes, p_, end);
                if (code >= 128) {
                    try {
                        sb.append(String.format(" 0x%04x ", code));
                    }
                    catch (IllegalFormatConversionException ifce) {
                        sb.append(code);
                    }
                    continue;
                }
                sb.append((char)code);
            }
        } else {
            while (p < end) {
                sb.append(new String(new byte[]{bytes[p]}));
                ++p;
            }
        }
        return sb.append("/").toString();
    }

    public String optimizeInfoToString() {
        String s2 = "";
        s2 = s2 + "optimize: " + this.searchAlgorithm.getName() + "\n";
        s2 = s2 + "  anchor:     " + OptAnchorInfo.anchorToString(this.anchor);
        if ((this.anchor & 0x18) != 0) {
            s2 = s2 + MinMaxLen.distanceRangeToString(this.anchorDmin, this.anchorDmax);
        }
        s2 = s2 + "\n";
        if (this.searchAlgorithm != SearchAlgorithm.NONE) {
            s2 = s2 + "  sub anchor: " + OptAnchorInfo.anchorToString(this.subAnchor) + "\n";
        }
        s2 = s2 + "dmin: " + this.dMin + " dmax: " + this.dMax + "\n";
        s2 = s2 + "threshold length: " + this.thresholdLength + "\n";
        if (this.exact != null) {
            s2 = s2 + "exact: [" + new String(this.exact, this.exactP, this.exactEnd - this.exactP) + "]: length: " + (this.exactEnd - this.exactP) + "\n";
        } else if (this.searchAlgorithm == SearchAlgorithm.MAP || this.searchAlgorithm == SearchAlgorithm.MAP_SB) {
            int n = 0;
            for (int i = 0; i < 256; ++i) {
                if (this.map[i] == 0) continue;
                ++n;
            }
            s2 = s2 + "map: n = " + n + "\n";
            if (n > 0) {
                int c = 0;
                s2 = s2 + "[";
                for (int i = 0; i < 256; ++i) {
                    if (this.map[i] == 0) continue;
                    if (c > 0) {
                        s2 = s2 + ", ";
                    }
                    ++c;
                    s2 = this.enc.maxLength() == 1 && this.enc.isPrint(i) ? s2 + (char)i : s2 + i;
                }
                s2 = s2 + "]\n";
            }
        }
        return s2;
    }

    public Encoding getEncoding() {
        return this.enc;
    }

    public int getOptions() {
        return this.options;
    }

    public void setUserOptions(int options) {
        this.userOptions = options;
    }

    public int getUserOptions() {
        return this.userOptions;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public Object getUserObject() {
        return this.userObject;
    }
}

