/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.org.hibernate.validator.internal.xml.mapping;

import java.lang.annotation.ElementType;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Executable;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import net.thisptr.java.prometheus.metrics.agent.shade.javax.validation.ValidationException;
import net.thisptr.java.prometheus.metrics.agent.shade.org.hibernate.validator.internal.engine.valueextraction.ValueExtractorManager;
import net.thisptr.java.prometheus.metrics.agent.shade.org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptionsImpl;
import net.thisptr.java.prometheus.metrics.agent.shade.org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import net.thisptr.java.prometheus.metrics.agent.shade.org.hibernate.validator.internal.metadata.core.MetaConstraint;
import net.thisptr.java.prometheus.metrics.agent.shade.org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import net.thisptr.java.prometheus.metrics.agent.shade.org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import net.thisptr.java.prometheus.metrics.agent.shade.org.hibernate.validator.internal.metadata.raw.ConstrainedParameter;
import net.thisptr.java.prometheus.metrics.agent.shade.org.hibernate.validator.internal.util.ReflectionHelper;
import net.thisptr.java.prometheus.metrics.agent.shade.org.hibernate.validator.internal.util.TypeResolutionHelper;
import net.thisptr.java.prometheus.metrics.agent.shade.org.hibernate.validator.internal.util.logging.Log;
import net.thisptr.java.prometheus.metrics.agent.shade.org.hibernate.validator.internal.util.logging.LoggerFactory;
import net.thisptr.java.prometheus.metrics.agent.shade.org.hibernate.validator.internal.xml.mapping.AbstractConstrainedElementStaxBuilder;
import net.thisptr.java.prometheus.metrics.agent.shade.org.hibernate.validator.internal.xml.mapping.ClassLoadingHelper;
import net.thisptr.java.prometheus.metrics.agent.shade.org.hibernate.validator.internal.xml.mapping.ContainerElementTypeConfigurationBuilder;
import net.thisptr.java.prometheus.metrics.agent.shade.org.hibernate.validator.internal.xml.mapping.DefaultPackageStaxBuilder;

class ConstrainedParameterStaxBuilder
extends AbstractConstrainedElementStaxBuilder {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private static final String PARAMETER_QNAME_LOCAL_PART = "parameter";
    private static final QName TYPE_QNAME = new QName("type");

    ConstrainedParameterStaxBuilder(ClassLoadingHelper classLoadingHelper, ConstraintHelper constraintHelper, TypeResolutionHelper typeResolutionHelper, ValueExtractorManager valueExtractorManager, DefaultPackageStaxBuilder defaultPackageStaxBuilder, AnnotationProcessingOptionsImpl annotationProcessingOptions) {
        super(classLoadingHelper, constraintHelper, typeResolutionHelper, valueExtractorManager, defaultPackageStaxBuilder, annotationProcessingOptions);
    }

    @Override
    Optional<QName> getMainAttributeValueQname() {
        return Optional.of(TYPE_QNAME);
    }

    @Override
    protected String getAcceptableQName() {
        return PARAMETER_QNAME_LOCAL_PART;
    }

    public Class<?> getParameterType(Class<?> beanClass) {
        try {
            return this.classLoadingHelper.loadClass(this.mainAttributeValue, this.defaultPackageStaxBuilder.build().orElse(""));
        }
        catch (ValidationException e) {
            throw LOG.getInvalidParameterTypeException(this.mainAttributeValue, beanClass);
        }
    }

    ConstrainedParameter build(Executable executable, int index) {
        ConstraintLocation constraintLocation = ConstraintLocation.forParameter(executable, index);
        Type type = ReflectionHelper.typeOf(executable, index);
        Set<MetaConstraint<?>> metaConstraints = this.constraintTypeStaxBuilders.stream().map(builder -> builder.build(constraintLocation, ElementType.PARAMETER, null)).collect(Collectors.toSet());
        ContainerElementTypeConfigurationBuilder.ContainerElementTypeConfiguration containerElementTypeConfiguration = this.getContainerElementTypeConfiguration(type, constraintLocation);
        if (this.ignoreAnnotations.isPresent()) {
            this.annotationProcessingOptions.ignoreConstraintAnnotationsOnParameter(executable, index, (Boolean)this.ignoreAnnotations.get());
        }
        ConstrainedParameter constrainedParameter = new ConstrainedParameter(ConfigurationSource.XML, executable, type, index, metaConstraints, containerElementTypeConfiguration.getMetaConstraints(), this.getCascadingMetaData(containerElementTypeConfiguration.getTypeParametersCascadingMetaData(), type));
        return constrainedParameter;
    }
}

