/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.tree.fieldaccess.resolved;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.NullNode;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Scope;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.misc.JsonNodeUtils;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.tree.fieldaccess.resolved.ResolvedFieldAccess;

public class ResolvedStringFieldAccess
extends ResolvedFieldAccess {
    private List<String> keys;

    public List<String> keys() {
        return Collections.unmodifiableList(this.keys);
    }

    public ResolvedStringFieldAccess(boolean permissive, List<String> keys) {
        super(permissive);
        this.keys = keys;
    }

    @Override
    public List<JsonNode> apply(Scope scope, JsonNode in) throws JsonQueryException {
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        for (String key : this.keys) {
            if (in.isNull()) {
                out.add(NullNode.getInstance());
                continue;
            }
            if (in.isObject()) {
                JsonNode n = in.get(key);
                out.add(n == null ? NullNode.getInstance() : n);
                continue;
            }
            if (this.permissive) continue;
            throw new JsonQueryException(String.format("Cannot index %s with string \"%s\"", JsonNodeUtils.typeOf(in), key));
        }
        return out;
    }
}

