/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.tree.fieldaccess.resolved;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Scope;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.tree.fieldaccess.resolved.ResolvedFieldAccess;

public class ResolvedAllFieldAccess
extends ResolvedFieldAccess {
    public ResolvedAllFieldAccess(boolean permissive) {
        super(permissive);
    }

    @Override
    public List<JsonNode> apply(Scope scope, JsonNode in) throws JsonQueryException {
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        if (in.isNull()) {
            if (!this.permissive) {
                throw new JsonQueryException("Cannot iterate over null");
            }
        } else if (in.isArray()) {
            Iterator<JsonNode> values = in.iterator();
            while (values.hasNext()) {
                out.add(values.next());
            }
        } else if (in.isObject()) {
            Iterator<Map.Entry<String, JsonNode>> fields = in.fields();
            while (fields.hasNext()) {
                out.add(fields.next().getValue());
            }
        } else if (!this.permissive) {
            throw JsonQueryException.format("Cannot iterate over %s", new Object[]{in.getNodeType()});
        }
        return out;
    }
}

