/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.TextNode;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Scope;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.misc.Pair;

public class StringInterpolation
extends JsonQuery {
    private List<Pair<Integer, JsonQuery>> interpolations;
    private String template;
    private JsonQuery formatter;

    public StringInterpolation(String template, List<Pair<Integer, JsonQuery>> interpolations, JsonQuery formatter) {
        this.template = template;
        this.interpolations = interpolations;
        this.formatter = formatter;
    }

    @Override
    public List<JsonNode> apply(Scope scope, JsonNode in) throws JsonQueryException {
        if (this.interpolations.isEmpty()) {
            return Collections.singletonList(new TextNode(this.template));
        }
        Stack<Pair<Integer, List<JsonNode>>> values = new Stack<Pair<Integer, List<JsonNode>>>();
        for (Pair<Integer, JsonQuery> entry : this.interpolations) {
            List<JsonNode> tmp = ((JsonQuery)entry._2).apply(scope, in);
            if (this.formatter != null) {
                tmp = this.formatter.apply(scope, tmp);
            }
            values.push(Pair.of(entry._1, tmp));
        }
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        Stack<Pair<Integer, JsonNode>> stack = new Stack<Pair<Integer, JsonNode>>();
        this.recurse(out, stack, values);
        return out;
    }

    private void recurse(List<JsonNode> out, Stack<Pair<Integer, JsonNode>> stack, Stack<Pair<Integer, List<JsonNode>>> values) {
        if (values.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            int pos = 0;
            for (int index = stack.size() - 1; index >= 0; --index) {
                Pair head = (Pair)stack.get(index);
                builder.append(this.template.substring(pos, (Integer)head._1));
                pos = (Integer)head._1;
                builder.append(((JsonNode)head._2).isValueNode() ? ((JsonNode)head._2).asText() : ((JsonNode)head._2).toString());
            }
            builder.append(this.template.substring(pos));
            out.add(new TextNode(builder.toString()));
        } else {
            Pair<Integer, List<JsonNode>> last = values.pop();
            for (JsonNode value : (List)last._2) {
                stack.push(Pair.of(last._1, value));
                this.recurse(out, stack, values);
                stack.pop();
            }
        }
    }

    public String toString() {
        int pos = 0;
        StringBuilder builder = new StringBuilder();
        if (this.formatter != null) {
            builder.append(this.formatter);
            builder.append(" ");
        }
        builder.append("\"");
        for (Pair<Integer, JsonQuery> interpolation : this.interpolations) {
            StringInterpolation.copyEscaped(builder, this.template, pos, (Integer)interpolation._1);
            pos = (Integer)interpolation._1;
            builder.append("\\(");
            builder.append(interpolation._2);
            builder.append(")");
        }
        StringInterpolation.copyEscaped(builder, this.template, pos, this.template.length());
        builder.append("\"");
        return builder.toString();
    }

    private static void copyEscaped(StringBuilder builder, String text, int begin, int end) {
        block9: for (int i = begin; i < end; ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\\': {
                    builder.append("\\\\");
                    continue block9;
                }
                case '\"': {
                    builder.append("\\\"");
                    continue block9;
                }
                case '\b': {
                    builder.append("\\b");
                    continue block9;
                }
                case '\f': {
                    builder.append("\\f");
                    continue block9;
                }
                case '\r': {
                    builder.append("\\r");
                    continue block9;
                }
                case '\t': {
                    builder.append("\\t");
                    continue block9;
                }
                case '\n': {
                    builder.append("\\n");
                    continue block9;
                }
                default: {
                    builder.append(ch);
                }
            }
        }
    }
}

