/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.tree;

import java.util.ArrayList;
import java.util.List;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Scope;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryTypeException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.misc.JsonNodeUtils;

public class NegativeExpression
extends JsonQuery {
    private JsonQuery value;

    public NegativeExpression(JsonQuery value) {
        this.value = value;
    }

    @Override
    public List<JsonNode> apply(Scope scope, JsonNode in) throws JsonQueryException {
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        for (JsonNode i : this.value.apply(scope, in)) {
            if (!i.isNumber()) {
                throw new JsonQueryTypeException(in, "cannot be negated");
            }
            out.add(JsonNodeUtils.asNumericNode(-i.asDouble()));
        }
        return out;
    }

    public String toString() {
        return "-(" + this.value.toString() + ")";
    }
}

