/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.functions;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.core.JsonGenerator;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.core.JsonProcessingException;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.core.Version;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonSerializer;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.ObjectMapper;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.SerializerProvider;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.module.SimpleModule;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.DoubleNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.FloatNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.TextNode;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Function;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Scope;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.BuiltinFunction;

@BuiltinFunction(value={"tojson/0"})
public class ToJsonFunction
implements Function {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private static String format(double val) {
        String repr;
        if (Double.isNaN(val)) {
            return "null";
        }
        if (Double.isInfinite(val) && val > 0.0) {
            val = Double.MAX_VALUE;
        }
        if (Double.isInfinite(val) && val < 0.0) {
            val = -1.7976931348623157E308;
        }
        if ((repr = Double.toString(val)).contains("E-")) {
            return repr.replace('E', 'e');
        }
        return repr.replace("E", "e+");
    }

    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        try {
            return Collections.singletonList(new TextNode(MAPPER.writeValueAsString(in)));
        }
        catch (IOException e) {
            throw new JsonQueryException(e);
        }
    }

    static {
        SimpleModule module = new SimpleModule("JsonQuery", new Version(1, 0, 0, null, "net.thisptr", "jackson-jq"));
        module.addSerializer(DoubleNode.class, new DoubleNodeSerializer());
        module.addSerializer(FloatNode.class, new FloatNodeSerializer());
        MAPPER.registerModule(module);
    }

    private static class FloatNodeSerializer
    extends JsonSerializer<FloatNode> {
        private FloatNodeSerializer() {
        }

        @Override
        public void serialize(FloatNode value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            gen.writeRaw(ToJsonFunction.format(value.asDouble()));
        }
    }

    private static class DoubleNodeSerializer
    extends JsonSerializer<DoubleNode> {
        private DoubleNodeSerializer() {
        }

        @Override
        public void serialize(DoubleNode value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            gen.writeRaw(ToJsonFunction.format(value.asDouble()));
        }
    }
}

